/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.beanql;

import ams.com.ams.beanql.BeanQLViewStatementSupport;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.exceptions.BeanQLResultEmptyException;
import ams.com.ams.beanql.exceptions.BeanQLResultMultiException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public class BeanQLViewPreparedStatement
extends BeanQLViewStatementSupport {
    private PreparedStatement preparedStatement;

    public BeanQLViewPreparedStatement(Class bean_class, PreparedStatement ps) throws BeanQLException {
        this.bean = bean_class;
        this.preparedStatement = ps;
        this.createBeanFieldListMap();
    }

    public Collection select() throws BeanQLException, SQLException {
        ArrayList<Object> result_list = new ArrayList<Object>();
        ResultSet result = this.preparedStatement.executeQuery();
        while (result.next()) {
            result_list.add(this.getBeanByResultSet(result));
        }
        result.close();
        return result_list;
    }

    public Object selectOne() throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        Collection col = this.select();
        if (col.isEmpty()) {
            throw new BeanQLResultEmptyException("\u691c\u7d22\u7d50\u679c 0\u4ef6");
        }
        if (col.size() > 1) {
            throw new BeanQLResultMultiException("\u691c\u7d22\u7d50\u679c " + col.size() + "\u4ef6");
        }
        Object o = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            o = it.next();
        }
        return o;
    }

    public void close() throws BeanQLException {
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException e) {
                throw new BeanQLException(e);
            }
        }
    }

    public static void closeSafe(BeanQLViewPreparedStatement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (BeanQLException e) {
            e.printStackTrace();
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        this.preparedStatement.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.preparedStatement.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.preparedStatement.setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.preparedStatement.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.preparedStatement.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.preparedStatement.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.preparedStatement.setClob(i, x);
    }

    public void setCursorName(String arg0) throws SQLException {
        this.preparedStatement.setCursorName(arg0);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.preparedStatement.setDouble(parameterIndex, x);
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.preparedStatement.setEscapeProcessing(arg0);
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.preparedStatement.setFetchDirection(arg0);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.preparedStatement.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.preparedStatement.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.preparedStatement.setLong(parameterIndex, x);
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        this.preparedStatement.setMaxFieldSize(arg0);
    }

    public void setMaxRows(int arg0) throws SQLException {
        this.preparedStatement.setMaxRows(arg0);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.preparedStatement.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        this.preparedStatement.setQueryTimeout(arg0);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.preparedStatement.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.preparedStatement.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.preparedStatement.setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setUnicodeStream(parameterIndex, x, length);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.preparedStatement.setURL(parameterIndex, x);
    }
}

