package jp.co.powerbeans.powerql;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>プロジェクト名: PowerQL</p>
 * <p>タイトル: TypeMappings</p>
 * <p>説明: Javaの型から、ResultSetから値を取得するメソッドを決定するメソッドマッピング情報を管理するクラス。</p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * @author 門田明彦
 * @version $Revision: 1.3 $
 */
public class TypeMappings {

	/** All Common type <-> ResultSet getter method mapping map */
	public static final Map java2ResultsetGetter = new HashMap();
	static {
		// DBカラムの型と ResultSet のgetMethodのマッピング
		// とりあえず mysql baseで
		//typeMap.put(" java type ", " DB type ");
//	    
//		java2ResultsetGetter.put("TINYINT", "getByte");
//		java2ResultsetGetter.put("INTEGER", "getInt");
//		java2ResultsetGetter.put("SMALLINT", "getShort");
//		java2ResultsetGetter.put("int", "getInt");
//		java2ResultsetGetter.put("INT", "getInt");
//		java2ResultsetGetter.put("BIGINT", "getLong");
//		java2ResultsetGetter.put("FLOAT", "getFloat");
//		java2ResultsetGetter.put("DOUBLE", "getDouble");
//		java2ResultsetGetter.put("DOUBLE_PRECISION", "getDouble");
//		java2ResultsetGetter.put("DATE", "getDate");
//		java2ResultsetGetter.put("TIMESTAMP", "getTimestamp");
//		java2ResultsetGetter.put("TIME", "getTime");
//		java2ResultsetGetter.put("CHAR", "getString");
//		java2ResultsetGetter.put("VARCHAR", "getString");
//		java2ResultsetGetter.put("CLOB", "getString");
//		java2ResultsetGetter.put("BLOB", "getBlob");
//		java2ResultsetGetter.put("DECIMAL", "getBigDecimal");
	    
	    
		java2ResultsetGetter.put("byte", "getByte");
		java2ResultsetGetter.put("short", "getShort");
		java2ResultsetGetter.put("int", "getInt");
		java2ResultsetGetter.put("long", "getLong");
		java2ResultsetGetter.put("float", "getFloat");
		java2ResultsetGetter.put("double", "getDouble");
		java2ResultsetGetter.put("boolean", "getBoolean");
		java2ResultsetGetter.put("java.lang.Byte", "getByte");
		java2ResultsetGetter.put("java.lang.Integer", "getInt");
		java2ResultsetGetter.put("java.lang.String", "getString");
		java2ResultsetGetter.put("java.sql.Timestamp", "getTimestamp");
		java2ResultsetGetter.put("java.sql.Time", "getTime");
		java2ResultsetGetter.put("java.sql.Date", "getDate");
		java2ResultsetGetter.put("java.util.Date", "getDate");
		java2ResultsetGetter.put("[B", "getObject");
        java2ResultsetGetter.put("java.sql.Blob", "getBytes"); // for DB2
//        java2ResultsetGetter.put("java.sql.Blob", "getBlob"); // for MySQL?, PgSQL?
        java2ResultsetGetter.put("java.sql.Clob", "getClob");
		java2ResultsetGetter.put("java.math.BigDecimal", "getBigDecimal");
		
//		java2ResultsetGetter.put("java.sql.Date", "getDate");
//		java2ResultsetGetter.put("java.util.Date", "getDate");
	}

	/** All Common type <-> ResultSet setter method mapping map */
	public static final Map java2ResultsetSetter = new HashMap();

	static {
		try {
	        // propertyの型と ResultSet のgetMethodのマッピング
	        // とりあえず mysql baseで
	        //typeMap.put(" java type ", " DB type ");
	        java2ResultsetSetter.put("byte", PreparedStatement.class.getMethod("setByte", new Class[]{int.class, byte.class}));
			java2ResultsetSetter.put("short", PreparedStatement.class.getMethod("setShort", new Class[]{int.class, short.class}));
			java2ResultsetSetter.put("int", PreparedStatement.class.getMethod("setInt", new Class[]{int.class, int.class}));
			java2ResultsetSetter.put("long", PreparedStatement.class.getMethod("setLong", new Class[]{int.class, long.class}));
			java2ResultsetSetter.put("float", PreparedStatement.class.getMethod("setFloat", new Class[]{int.class, float.class}));
			java2ResultsetSetter.put("double", PreparedStatement.class.getMethod("setDouble", new Class[]{int.class, double.class}));
			java2ResultsetSetter.put("boolean", PreparedStatement.class.getMethod("setBoolean", new Class[]{int.class, boolean.class}));
			java2ResultsetSetter.put("java.lang.Byte", PreparedStatement.class.getMethod("setByte", new Class[]{int.class, byte.class}));
			java2ResultsetSetter.put("java.lang.Integer", PreparedStatement.class.getMethod("setInt", new Class[]{int.class, int.class}));
			java2ResultsetSetter.put("java.lang.String", PreparedStatement.class.getMethod("setString", new Class[]{int.class, String.class}));
			java2ResultsetSetter.put("java.sql.Timestamp", PreparedStatement.class.getMethod("setTimestamp", new Class[]{int.class, Timestamp.class}));
			java2ResultsetSetter.put("java.sql.Time", PreparedStatement.class.getMethod("setTime", new Class[]{int.class, Time.class}));
			java2ResultsetSetter.put("java.sql.Date", PreparedStatement.class.getMethod("setDate", new Class[]{int.class, java.sql.Date.class}));
			java2ResultsetSetter.put("java.util.Date", PreparedStatement.class.getMethod("setDate", new Class[]{int.class, java.sql.Date.class}));
			java2ResultsetSetter.put("[B", PreparedStatement.class.getMethod("setBytes", new Class[]{int.class, byte[].class}));
            java2ResultsetSetter.put("java.sql.Blob", PreparedStatement.class.getMethod("setBlob", new Class[]{int.class, Blob.class}));
            java2ResultsetSetter.put("java.sql.Clob", PreparedStatement.class.getMethod("setClob", new Class[]{int.class, Clob.class}));
			java2ResultsetSetter.put("java.math.BigDecimal", PreparedStatement.class.getMethod("setBigDecimal", new Class[]{int.class, BigDecimal.class}));
			
			java2ResultsetSetter.put("org.postgresql.geometric.PGpoint", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("org.postgresql.geometric.PGcircle", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("org.postgresql.geometric.PGline", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("org.postgresql.geometric.PGlseg", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("org.postgresql.geometric.PGpath", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("org.postgresql.geometric.PGpoint", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("org.postgresql.geometric.PGpolygon", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("org.postgresql.geometric.PGbox", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			java2ResultsetSetter.put("[Lorg.postgresql.geometric.PGline;", PreparedStatement.class.getMethod("setObject", new Class[]{int.class, Object.class}));
			
        } catch (Exception e) {
            e.printStackTrace();
        }
	}

}

