package jp.co.powerbeans.powerql.dao;

import java.util.ArrayList;
import java.util.Collection;

import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.POQLTransaction;
import jp.co.powerbeans.powerql.POQLViewPreparedStatement;

/**
 * <p>
 * RawSqlDAOの基本実装クラス
 * </p>
 * <p>
 * SQLを直接指定して検索するDAO
 * </p>
 * <p>
 * create date 2005/11/11
 * </p>
 * 
 * @author Monden Akihiko
 * @version $Revision$
 */
public class POQLStandardRawSqlDAO extends POQLRawSqlBaseDAO {

    /**
     * コンストラクタ
     * @param manager POQLManager
     */
    public POQLStandardRawSqlDAO(POQLManager manager) {
        super(manager);
    }

    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLRawSqlDAO#find(java.lang.String, java.lang.Class)
     */
    public Collection find(String sql, Class bean_class) {
        POQLTransaction bqlTrn = null;
        POQLViewPreparedStatement st = null;
        try {
            bqlTrn = getPowerQLTransaction();
            st = bqlTrn.createViewPreparedStatement(bean_class, sql);
            return st.select();
        } catch (Exception e) {
            onException(e);
        } finally {
            setLastSqlSafe(st);
            close(bqlTrn);
        }
        return new ArrayList();
    }


    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLRawSqlDAO#find(java.lang.String, java.lang.Class)
     */
    public Object find1(String sql, Class bean_class) {
        POQLTransaction bqlTrn = null;
        POQLViewPreparedStatement st = null;
        try {
            bqlTrn = getPowerQLTransaction();
            st = bqlTrn.createViewPreparedStatement(bean_class, sql);
            return st.selectOne();
        } catch (Exception e) {
            onException(e);
        } finally {
            setLastSqlSafe(st);
            close(bqlTrn);
        }
        return null;
    }
}
