package jp.co.powerbeans.powerql.exceptions;

/**
 * <p>プロジェクト名: PowerQL</p>
 * <p>タイトル: POQLNotExistResultException</p>
 * <p>説明: BeanProperty の name と対応する値が検索結果のSELECT句に存在しない場合スローされる例外。</p>
 * <p>通常は無視して値を取得しない。</p>
 * 
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class POQLNotExistResultException extends Exception {

  /**
   * コンストラクタ
   */
  public POQLNotExistResultException() {
    super();
  }

  /**
   * コンストラクタ
   * @param message メッセージ
   */
  public POQLNotExistResultException(String message) {
    super(message);
  }

  /**
   * コンストラクタ
   * @param message メッセージ
   * @param cause ラップする例外
   */
  public POQLNotExistResultException(String message, Throwable cause) {
    super(message, cause);
  }

  /**
   * コンストラクタ
   * @param cause ラップする例外
   */
  public POQLNotExistResultException(Throwable cause) {
    super(cause);
  }

}
