package jp.co.powerbeans.powerql.exceptions;

/**
 * <p>タイトル: POQLPKNotFoundException</p>
 * <p>説明: findByPrimaryKey利用時にPowerQL内部でPKを取得できなかった場合
 * スローされる。<BR>
 * PKのカラム名とフィールド名が一致していない場合発生する。</p>
 * 
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/17</p>
 * @author 門田明彦
 * @version $Revision$
 */
public class POQLPKNotFoundException extends Exception {

	/**
	 * コンストラクタ
	 */
	public POQLPKNotFoundException() {
		super();
	}

	/**
	 * コンストラクタ
	 * @param message メッセージ
	 */
	public POQLPKNotFoundException(String message) {
		super(message);
	}

	/**
	 * コンストラクタ
	 * @param message メッセージ
	 * @param cause 例外
	 */
	public POQLPKNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタ
	 * @param cause 例外
	 */
	public POQLPKNotFoundException(Throwable cause) {
		super(cause);
	}

}
