package jp.co.powerbeans.powerql;

import java.io.Serializable;
import java.lang.reflect.Method;

/**
 * <p>タイトル: BeanProperty</p>
 * <p>説明: JavaBeanのpropertyを保持するクラス</p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/16</p>
 * @author 門田明彦
 * @version $Revision: 1.2 $
 */
public class BeanProperty implements Serializable {

	/** property type */
	Class type;

	/** property name */
	String name;

	/** get method */
	Method m_get;

	/** set method */
	Method m_set;

	/** database column property */
	ColumnProperty columnProp;

	private String column_property_escaped_name;

	/**
	 * コンストラクタ
	 */
	private BeanProperty() {
		super();
	}

	/**
	 * コンストラクタ
	 * @param type
	 * @param name
	 * @param m_get
	 * @param m_set
	 */
	public BeanProperty(Class type, String name, Method m_get, Method m_set) {

		this.type = type;
		this.name = name;
		this.m_get = m_get;
		this.m_set = m_set;
	}

	/**
	 * getM_get<BR>
	 * @return getterメソッド
	 */
	public Method getM_get() {
		return m_get;
	}

	/**
	 * getM_set<BR>
	 * @return setterメソッド
	 */
	public Method getM_set() {
		return m_set;
	}

	/**
	 * getName<BR>
	 * @return プロパティ名
	 */
	public String getName() {
		return name;
	}

	/**
	 * getType<BR>
	 * @return 型
	 */
	public Class getType() {
		return type;
	}

	/**
	 * setM_get<BR>
	 * @param method
	 */
	public void setM_get(Method method) {
		m_get = method;
	}

	/**
	 * setM_set<BR>
	 * @param method
	 */
	public void setM_set(Method method) {
		m_set = method;
	}

	/**
	 * setName<BR>
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * setType<BR>
	 * @param class1
	 */
	public void setType(Class class1) {
		type = class1;
	}

	/**
	 * getColumnProp<BR>
	 * @return カラムプロパティ
	 */
	public ColumnProperty getColumnProp() {
		return columnProp;
	}

	/**
	 * setColumnProp<BR>
	 * @param property
	 */
	public void setColumnProp(ColumnProperty property) {
		columnProp = property;
	}
	
	/**
	 * @param column_property_escaped_name
	 */
	public void setColumnPropEscapedName(String column_property_escaped_name) {
		this.column_property_escaped_name = column_property_escaped_name;
	}
	
	/**
	 * @return
	 */
	public String getColumnPropEscapedName() {
		return this.column_property_escaped_name;
	}

}
