package jp.co.powerbeans.powerql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;

/**
 * Blob実装。INSERT,UPDATE では file,bytes,is のいずれかが not null でないこと。
 * 検索後の取得時は bytes のみ not null になっている。<BR>
 * 呼び出し側は getBytes で byte配列を取得するか、
 * outputFile でディスクに書き込むことができる。
 * 
 * 
 * @author A.Monden
 */
public class PoqlBlob implements java.sql.Blob, Serializable {

    /** バッファサイズ */
    private long length;
    /** ファイルオブジェクト */
    private File file;
    /** バイトイメージ */
    private byte[] bytes;
    /** DB格納用InputStream */
    private InputStream is;

    /**
     * byte[]指定コンストラクタ 
     */
    public PoqlBlob(byte[] bytes) {
        super();
        if (bytes != null) {
            this.bytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bytes, 0, this.bytes.length);
        } else {
            this.bytes = new byte[0];
        }
        this.length = this.bytes.length;
    }

    /**
     *  ファイル指定コンストラクタ
     */
    public PoqlBlob(File file) {
        super();
        if (file != null) {
            this.file = file;
            this.length = file.length();
        }
    }

    /**
     *  
     */
    public PoqlBlob(InputStream is) {
        super();
        this.is = is;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#length()
     */
    public long length() throws SQLException {
        
        if (bytes != null) {
            return bytes.length;
        }
        
        return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#getBytes(long, int)
     */
    public byte[] getBytes(long arg0, int arg1) throws SQLException {
        
        if (bytes != null) {
            byte[] rb = new byte[arg1];
            System.arraycopy(bytes, (int)arg0, rb, 0, rb.length);
            return rb;
        }
        
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#getBinaryStream()
     */
    public InputStream getBinaryStream() throws SQLException {
        // 格納オブジェクトの種類によって分岐
        if (is != null) {
            // InputStream
            return is;
            
        } else if (file != null) {
            // FILE
            try {
                return new FileInputStream(file);
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            return null;
            
        } else if (bytes != null) {
            
            return new ByteArrayInputStream(bytes);
        }
        
        // ここに到達することはありえない
        
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#position(byte[], long)
     */
    public long position(byte[] arg0, long arg1) throws SQLException {
        // TODO Auto-generated method stub
        return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#position(java.sql.PoqlBlob, long)
     */
    public long position(java.sql.Blob arg0, long arg1) throws SQLException {
        // TODO Auto-generated method stub
        return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#setBytes(long, byte[])
     */
    public int setBytes(long arg0, byte[] arg1) throws SQLException {
        // TODO Auto-generated method stub
        return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#setBytes(long, byte[], int, int)
     */
    public int setBytes(long arg0, byte[] arg1, int arg2, int arg3)
            throws SQLException {
        // TODO Auto-generated method stub
        return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#setBinaryStream(long)
     */
    public OutputStream setBinaryStream(long arg0) throws SQLException {
        // TODO Auto-generated method stub
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.PoqlBlob#truncate(long)
     */
    public void truncate(long arg0) throws SQLException {
        // TODO Auto-generated method stub

    }

	public void free() throws SQLException {
		// TODO Auto-generated method stub
		
	}

	public InputStream getBinaryStream(long pos, long length)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
    
//    /**
//     * byte[] データをfull_filepathに出力する。
//     * full_filepatは新規作成する。
//     * @param full_filepath ファイルへのフルパス
//     */
//    public void outputFile(String full_filepath) {
//        // AMS TODO
//    }

}