/**
 * 
 */
package jp.co.powerbeans.powerql.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.POQLPreparedStatement;
import jp.co.powerbeans.powerql.POQLStatement;
import jp.co.powerbeans.powerql.POQLTransaction;
import jp.co.powerbeans.powerql.exceptions.POQLResultEmptyException;
import jp.co.powerbeans.powerql.exceptions.POQLResultMultiException;
import jp.co.powerbeans.powerql.vendor.DBDependQLStatement;
import jp.co.powerbeans.powerql.vendor.DBDependQLStatementFactory;

/**
 * @author uu027189
 *
 */
public class POQLMapBaseDAO extends POQLBaseDAO implements POQLMapDAO {

	private String tableName;
	private Object geleratedKey;

	/**
	 * @param manager
	 */
	public POQLMapBaseDAO(POQLManager manager, String table_name) {
		super(manager, null);
		this.tableName = table_name;
		setThrowException(manager.isThrowException());
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#countBy(java.lang.String)
	 */
	public int countBy(String where) {
        POQLTransaction bqlTrn = null;
        int count = 0;
        POQLStatement st = null;
        try {
            bqlTrn = getPowerQLTransaction();
            st = bqlTrn.createStatement(getBeanClass());
            count = st.count(where);

        } catch (Exception e) {
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        return count;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#countByAll()
	 */
	public int countByAll() {
		return countBy(null);
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#create(java.lang.Object)
	 */
	public int create(Object bean) {
		return create(bean, null);
    }

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#create(java.lang.Object, java.lang.String[])
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#create(java.lang.Object, java.lang.String[])
	 */
	public int create(Object bean, String[] columns) {

        if (bean == null) {
            return 0;
        }
        
        if (bean.getClass().isArray()) {
            int c = 0;
            Object[] objs = (Object[])bean;
            for(int i = 0; i < objs.length; i++) {
                c += create(objs[i]);
            }
            return c;
        } else if (bean instanceof Collection) {
            Collection col = (Collection)bean;
            int c = 0;
            for(Iterator it = col.iterator(); it.hasNext();) {
                c += create(it.next());
            }
            return c;
        }
        
        // 配列,リスト以外ではMap型のみ許可
        if (!(bean instanceof Map)) {
        	throw new RuntimeException("parameter is not instance of Map.");
		}
        Map bean_map = (Map) bean;
        POQLTransaction bqlTrn = null;
        POQLPreparedStatement st = null;
        int num = 0;
        try {
            bqlTrn = getPowerQLTransaction();
            Set colset = createColSet(columns);
//            POQLStatement st = bqlTrn.createStatement(getBeanClass());
//            st = bqlTrn.createPreparedStatement_forInsert(getBeanClass());
            List<Object> vals_list = new ArrayList<Object>();
            st = bqlTrn.createPreparedStatement_forInsertWithColumns(tableName, bean_map, vals_list, colset);
			Object[] vals = vals_list.toArray(new Object[vals_list.size()]);
			st.setPreparedValues(vals);
            num = st.insertByObjArray(vals);
//            num = st.insert(bean_map);
            
            // 追加したレコードのIDを取得し変数に格納しておく
            this.geleratedKey = getGeneratedKey(bqlTrn, st);
            // IDを上書きしてしまう
            bean_map.put(tableName + "_id", this.geleratedKey);
//            setAutoGenerateKeyValue(bean, bqlTrn, st);

            commitSafe();
            
        } catch (Exception e) {
            onRollback();
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        return num;	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#createByPowerQLSeq(java.lang.Object)
	 */
	public int createByPowerQLSeq(Object bean) {
		throw new RuntimeException("unsupport method.");
//		return 0;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#dropTable(java.lang.Class)
	 */
	public void dropTable(Class bean_class) {
		throw new RuntimeException("unsupport method.");
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#find1By(java.lang.String)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#find1By(java.lang.String)
	 */
	public Object find1By(String where) {
		throw new RuntimeException("unsupport method.");
//		return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findBy(java.lang.String)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#findBy(java.lang.String)
	 */
	public Collection findBy(String where) {
		return findBy(where, null);
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findBy(java.lang.String, java.lang.String)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#findBy(java.lang.String, java.lang.String)
	 */
	public Collection findBy(String where, String order_by) {
        POQLTransaction bqlTrn = null;
        POQLPreparedStatement st = null;
        Collection col = null;
        String where_safe = where == null || where.length() == 0 ? "":where;
        String order_by_safe = order_by == null || order_by.length() == 0 ? "":order_by;
        
        try {
            bqlTrn = getPowerQLTransaction();
            // ベンダー依存Statementを取得
            DBDependQLStatement dbst = DBDependQLStatementFactory.create(bqlTrn
                    .getConnection(), this.getManager());
            
            bqlTrn = getPowerQLTransaction();
            final String sql = " select * from " + dbst.escape(this.tableName) + 
            	 " " + where_safe + " " + order_by_safe;
            st = bqlTrn.createPreparedStatement(sql);
//            st = bqlTrn.createStatement(getBeanClass());
            col = st.selectToMap();
//            col = st.select(where, null, order_by);

        } catch (Exception e) {
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        if (col == null) {
            col = new ArrayList();
        }
        return col;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#findBy(java.lang.String, java.lang.String, java.lang.Object)
	 */
	public Collection findBy(String where, String order_by, Object ... vals) {
        POQLTransaction bqlTrn = null;
        POQLPreparedStatement st = null;
        Collection col = null;
        String where_safe = where == null || where.length() == 0 ? "":" where " + where;
        String order_by_safe = order_by == null || order_by.length() == 0 ? "":" order by " + order_by;
        
        try {
            bqlTrn = getPowerQLTransaction();
            // ベンダー依存Statementを取得
            DBDependQLStatement dbst = DBDependQLStatementFactory.create(bqlTrn
                    .getConnection(), this.getManager());
            
            bqlTrn = getPowerQLTransaction();
            final String sql = " select * from " + dbst.escape(this.tableName) + 
            	 " " + where_safe + " " + order_by_safe;
            st = bqlTrn.createPreparedStatement(sql);
            st.setPreparedValues(vals);
//            st = bqlTrn.createStatement(getBeanClass());
            col = st.selectToMap();
//            col = st.select(where, null, order_by);

        } catch (Exception e) {
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        if (col == null) {
            col = new ArrayList();
        }
        return col;
	}
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#find(java.lang.String, java.lang.Object[])
	 */
	public Collection find(String sql, Object ... vals) {
        POQLTransaction bqlTrn = null;
        POQLPreparedStatement st = null;
        Collection col = null;
        
        try {
            bqlTrn = getPowerQLTransaction();
            // ベンダー依存Statementを取得
            DBDependQLStatement dbst = DBDependQLStatementFactory.create(bqlTrn
                    .getConnection(), this.getManager());
            
            bqlTrn = getPowerQLTransaction();
            st = bqlTrn.createPreparedStatement(sql);
            st.setPreparedValues(vals);
            col = st.selectToMap();

        } catch (Exception e) {
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        if (col == null) {
            col = new ArrayList();
        }
        return col;
	}
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#find(java.lang.String, java.lang.Object[])
	 */
	public Map find1(String sql, Object ... vals) {
        POQLTransaction bqlTrn = null;
        POQLPreparedStatement st = null;
        Map col = null;
        
        try {
            bqlTrn = getPowerQLTransaction();
            // ベンダー依存Statementを取得
            DBDependQLStatement dbst = DBDependQLStatementFactory.create(bqlTrn
                    .getConnection(), this.getManager());
            
            bqlTrn = getPowerQLTransaction();
            st = bqlTrn.createPreparedStatement(sql);
            st.setPreparedValues(vals);
            col = st.selectOneToMap();

        } catch (Exception e) {
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        if (col == null) {
//            col = new HashMap();
        }
        return col;
	}
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#findByAll()
	 */
	public Collection findByAll() {
		return findBy("","");
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findByAll(java.lang.String)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#findByAll(java.lang.String)
	 */
	public Collection findByAll(String order_by) {
		return findBy("", order_by);
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findByPrimaryKey(java.lang.Object)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#findByPrimaryKey(java.lang.Object)
	 */
	public Object findByPrimaryKey(Object obj) {
        POQLTransaction bqlTrn = null;
        
        try {
	        bqlTrn = getPowerQLTransaction();
	        // ベンダー依存Statementを取得
	        DBDependQLStatement dbst = DBDependQLStatementFactory.create(bqlTrn
	                .getConnection(), this.getManager());
	        
			String where = 
				" " + dbst.escape(this.tableName + "_id") + " = ?";
			Collection col = findBy(where, "", obj);
			if (col.isEmpty()) {
				throw new POQLResultEmptyException("検索結果 0件");
			} else if (col.size() > 1) {
				throw new POQLResultMultiException("検索結果 " + col.size() + "件");
			}
			
			Object o = null;
			for(Iterator it = col.iterator(); it.hasNext();) {
				o = it.next(); 
			}
			return o;
			
        } catch (Exception e) {
            onException(e);
        } finally {
            closeSafe();
        }
        return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findByPrimaryKey(int)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#findByPrimaryKey(int)
	 */
	public Object findByPrimaryKey(int id) {
        return findByPrimaryKey(new Integer(id));
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#remove(java.lang.Object)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#remove(java.lang.Object)
	 */
	public int remove(Object bean) {
        if (!(bean instanceof Map)) {
        	throw new RuntimeException("parameter is not instance of Map.");
		}
        Map bean_map = (Map) bean;
		return removeByPrimaryKey(bean_map.get(this.tableName + "_id"));
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeBy(java.lang.String)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#removeBy(java.lang.String)
	 */
	public int removeBy(String where) {
        POQLTransaction bqlTrn = null;
        POQLStatement st = null;
        int num = 0;
        try {
            bqlTrn = getPowerQLTransaction();
            st = bqlTrn.createStatementByTableName(this.tableName);
            num = st.delete(where);
            commitSafe();
            
        } catch (Exception e) {
            onRollback();
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        return num;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeByAll()
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#removeByAll()
	 */
	public int removeByAll() {
		return removeBy("");
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeByPrimaryKey(java.lang.Object)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#removeByPrimaryKey(java.lang.Object)
	 */
	public int removeByPrimaryKey(Object key) {
        if (key == null) {
            return 0;
        }
        
        if (key.getClass().isArray()) {
            int c = 0;
            Object[] objs = (Object[])key;
            for(int i = 0; i < objs.length; i++) {
                c += removeByPrimaryKey(objs[i]);
            }
            return c;
        } else if (key instanceof Collection) {
            Collection col = (Collection)key;
            int c = 0;
            for(Iterator it = col.iterator(); it.hasNext();) {
                c += removeByPrimaryKey(it.next());
            }
            return c;
        }
        
        POQLTransaction bqlTrn = null;
        POQLPreparedStatement st = null;
        int num = 0;
        try {
            bqlTrn = getPowerQLTransaction();
	        // ベンダー依存Statementを取得
	        DBDependQLStatement dbst = DBDependQLStatementFactory.create(bqlTrn
	                .getConnection(), this.getManager());
	        String sql =
	        	"DELETE FROM " + dbst.escape(this.tableName) +
	        	" WHERE " + dbst.escape(this.tableName) + "_id = ?";
            st = bqlTrn.createPreparedStatement(sql);
//            BeanProperty[] pk_bps = st.getPrimaryKeyBeanProperty();
//            if (pk_bps.length > 0) {
//                // プライマリキーは1個として扱う
//                where = pk_bps[0].getColumnProp().getName() + " = "
//                        + POQLPreparedStatement.formatVal(key);
//            }
            st.setPreparedValues(new Object[]{key});
            num = st.update();
            commitSafe();
            
        } catch (Exception e) {
            onRollback();
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        return num;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeByPrimaryKey(int)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#removeByPrimaryKey(int)
	 */
	public int removeByPrimaryKey(int key) {
		return removeByPrimaryKey(new Integer(key));
	}


	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#update(java.lang.Object)
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#update(java.lang.Object)
	 */
	public int update(Object bean) {
		return update(bean,null);
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#update(java.lang.Object, java.lang.String[])
	 */
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#update(java.lang.Object, java.lang.String[])
	 */
	public int update(Object bean, String[] columns) {
        if (bean == null) {
            return 0;
        }
        
        if (bean.getClass().isArray()) {
            int c = 0;
            Object[] objs = (Object[])bean;
            for(int i = 0; i < objs.length; i++) {
                c += update(objs[i], columns);
            }
            return c;
        } else if (bean instanceof Collection) {
            Collection col = (Collection)bean;
            int c = 0;
            for(Iterator it = col.iterator(); it.hasNext();) {
                c += update(it.next(), columns);
            }
            return c;
        }        
        // 配列,リスト以外ではMap型のみ許可
        if (!(bean instanceof Map)) {
        	throw new RuntimeException("parameter is not instance of Map.");
		}
        Map bean_map = (Map) bean;
        POQLTransaction bqlTrn = null;
        POQLPreparedStatement st = null;
        int num = 0;
        try {
            bqlTrn = getPowerQLTransaction();
            Set colset = createColSet(columns);
            List<Object> vals_list = new ArrayList<Object>();
            st = bqlTrn.createPreparedStatement_forUpdateWithColumns(this.tableName, bean_map, "", colset, vals_list);
            
            // FOR UPDATE でエラーとならないように autoCommit を OFF にする
            bqlTrn.setAutoCommit(false);
			st.setPreparedValues(vals_list.toArray(new Object[vals_list.size()]));
            num = st.update();
            
//            num = st.updateExclusive(bean, getExclusiveCheckField(), colset);
            commitSafe();
            
        } catch (Exception e) {
            onRollback();
            onException(e);
        } finally {
            setLastSqlSafe(st);
            closeSafe();
        }
        
        return num;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLMapDAO#getGeleratedKey()
	 */
	public Object getGeleratedKey() {
		return geleratedKey;
	}
}