package jp.co.powerbeans.powerql.dao;

import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.POQLStatementIF;
import jp.co.powerbeans.powerql.POQLTransaction;
import jp.co.powerbeans.powerql.exceptions.POQLException;

/**
 * <p>
 * POQLRawSqlDAOの抽象実装クラス
 * </p>
 * <p>
 * RawSqlDAOを実装する場合はこのクラスを継承すること
 * </p>
 * <p>
 * create date 2005/11/11
 * </p>
 * 
 * @author Monden Akihiko
 * @version $Revision$
 */
public abstract class POQLRawSqlBaseDAO extends CoreRawSqlDAO implements POQLRawSqlDAO {

    /** 動作中のトランザクション */
    private POQLTransaction bqlTrn;
    
//    /** 排他チェックフィールド名 */
//    private String exclusiveCheckField;

    /** 1メソッドでトランザクションを完結するかどうか, true:完結する, false 完結しない */
    private boolean singleCallMethod;
    
    /** DAOで最後に実行したSQL */
    protected String lastSQL;

    /** DAOで最後に実行したSQLのbinds値 */
    protected Object[] lastBindValues;

    /** 自動で現在日付を格納するタイムスタンプフィールド名 */
    protected String[] autoTimestampColName;

    /** JTA等の外部トランザクション管理モードフラグ, true JTA利用, false JTA非利用(default) */
    private boolean useJTATransaction;

    
    /**
     * コンストラクタ
     * @param manager POQLManager
     */
    public POQLRawSqlBaseDAO(POQLManager manager) {
        super(manager);
    }

    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLRawSqlDAO#getLastSQL()
     */
    public String getLastSQL() {
        return this.lastSQL;
    }

    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLRawSqlDAO#getLastBindValues()
     */
    public Object[] getLastBindValues() {
        return new Object[]{};
    }

    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLRawSqlDAO#isUseJTATransaction()
     */
    public boolean isUseJTATransaction() {
        return useJTATransaction;
    }

    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLRawSqlDAO#setUseJTATransaction(boolean)
     */
    public void setUseJTATransaction(boolean useJTATransaction) {
        this.useJTATransaction = useJTATransaction;
    }
    /**
     * @return @throws
     *         POQLException
     */
    protected POQLTransaction getPowerQLTransaction() throws POQLException {
        POQLTransaction poql_trn = getManager().getPowerQLTransaction();
        poql_trn.setAutoTimestampColName(this.autoTimestampColName);
        poql_trn.setRtrim(isRtrim());
        return poql_trn;
    }

    /**
     * POQLStatementが存在する場合、最後に実行したSQLを返す。
     * 
     * @param st SQLを実行したPOQLStatement
     */
    protected void setLastSqlSafe(POQLStatementIF st) {
        if (st != null) {
            lastSQL = st.getLastSQL();
            lastBindValues = st.getLastBindValues();
        }
    }
}
