package jp.co.powerbeans.powerql.dao;

import java.util.ArrayList;
import java.util.Collection;

import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.POQLTransaction;
import jp.co.powerbeans.powerql.POQLViewPreparedStatement;


/**
 * POQLViewDAO基本実装クラス。
 * 
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * @author A.Monden
 */
public class POQLStandardViewDAO extends POQLDynaViewBaseDAO implements POQLViewDAO{

    /**
     * @param manager
     * @param c
     */
    public POQLStandardViewDAO(POQLManager manager, Class c) {
        super(manager, c);
    }

    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#findBy(java.lang.String)
     */
    public Collection findBy(String where) {
        
        return findBy(where, "");
    }    
    
    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#findBy(java.lang.String,java.lang.String)
     */
    public Collection findBy(String where, String order_by) {
        POQLTransaction bqlTrn = null;
        Collection list = null;
        try {
            bqlTrn = getPowerQLTransaction();
            StringBuffer sql = new StringBuffer(getDviewSql());
            
            if (where != null && where.trim().length() > 0) {
                sql.append(" WHERE ");
                sql.append(where);
            }
            if (order_by != null && order_by.trim().length() > 0) {
                sql.append(" ORDER BY ");
                sql.append(order_by);
            }
            
            POQLViewPreparedStatement st = bqlTrn.createViewPreparedStatement(
                    getBeanClass(), sql.toString());
            list = st.select();

        } catch (Exception e) {
            onException(e);
        } finally {
            close(bqlTrn);
        }

        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#find1By(java.lang.String)
     */
    public Object find1By(String where) {
        return find1By(where, "");
    }


    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#find1By(java.lang.String, java.lang.String)
     */
    public Object find1By(String where, String order_by) {
        POQLTransaction bqlTrn = null;
        Object bean = null;
        try {
            bqlTrn = getPowerQLTransaction();
            StringBuffer sql = new StringBuffer(getDviewSql());
            
            if (where != null && where.trim().length() > 0) {
                sql.append(" WHERE ");
                sql.append(where);
            }
            if (order_by != null && order_by.trim().length() > 0) {
                sql.append(" ORDER BY ");
                sql.append(order_by);
            }
            
            POQLViewPreparedStatement st = bqlTrn.createViewPreparedStatement(
                    getBeanClass(), sql.toString());
            bean = st.selectOne();

        } catch (Exception e) {
            onException(e);
        } finally {
            close(bqlTrn);
        }

        if (bean == null) {
            bean = createSafeBean();
        }
        return bean;
    }

    /* (non-Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#findByAll()
     */
    public Collection findByAll() {
        
        return findBy(null);
        
    }


}
