package jp.co.powerbeans.powerql.dao;

/**
 * <p>タイトル: POQLViewDAO</p>
 * <p>説明: VIEWから検索するメソッドを提供する汎用POQLDAOインターフェース。<BR>
 * すでにDBMSに登録済みのVIEWにアクセスするSQLを作成しDBにアクセスする。<BR><BR>
 * 通常ビジネスロジックは POQLManager#createViewDAO(Class) により
 * POQLViewDAOインスタンスを取得し、各メソッドで
 * DBにアクセスする。<BR><BR>
 * 
 * POQLViewDAOは検索のみで、追加、更新、削除を行うメソッドは提供していない。<BR>
 * <BR>
 * <pre>
 * 例）   // 既にDBに登録している VIEWPREFCITY を検索するDAOを生成し検索結果を ViewPrefCityクラスに返す。
 *        POQLManager bm = new POQLManager("org.postgresql.Driver",
 *               "jdbc:postgresql:bqltest", "trans",
 *               "t79rp90", "POQL_SEQUENCE");
 * 
 *        // DAO 生成
 *        POQLDynaViewDAO dao = bm.createViewDAO(ViewPrefCity.class); // View名と一致するモデルクラス
 * 
 *        // 検索
 *        Collection c = dao.findBy("regionName Like '%大通東%'");
 * 
 *        // c には ViewPrefCity モデルインスタンスのリストが格納されている。
 * 
 *
 * デフォルト値
 *   getThrowException() = false
 *   isReturnNull() = true
 *   
 * </pre>
 * 　
 * 
 * </p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/16</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public interface POQLViewDAO extends POQLDynaViewDAO {


}
