package jp.co.powerbeans.powerql.vendor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.POQLPreparedStatement;
import jp.co.powerbeans.powerql.POQLUtil;
import jp.co.powerbeans.powerql.exceptions.POQLException;

import org.apache.oro.text.perl.Perl5Util;


public class DBDependQLStatementHSQL extends DBDependQLStatementSupport
{

    public DBDependQLStatementHSQL()
    {
    }

    public ArrayList getColumnPropertyList(String table, String schema)
        throws SQLException, POQLException
    {
        ArrayList list = new ArrayList();
        String sql = "select COLUMN_NAME AS column_name,        TYPE_NAME,        COLUMN_SIZE AS data_length,        IS_NULLABLE,        COLUMN_DEF AS data_default,        PK.PK_NAME, KEY_SEQ from INFORMATION_SCHEMA.SYSTEM_COLUMNS SC LEFT OUTER JOIN INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS PK  ON SC.TABLE_NAME = PK.TABLE_NAME AND  SC.COLUMN_NAME = PK.COLUMN_NAME where SC.TABLE_NAME = '" + table.toUpperCase() + "' " + "order by ORDINAL_POSITION ";
        ResultSet result = statement.executeQuery(sql.toString());
        HashMap colMap = new HashMap();
        while(result.next()) 
        {
            ColumnProperty cp = new ColumnProperty();
            cp.setName(result.getString("column_name"));
            if(!colMap.containsKey(cp.getName()))
            {
                cp.setTypeAsDB(result.getString("TYPE_NAME"));
                cp.setNullable(result.getString("IS_NULLABLE").equals("YES"));
                cp.setDefaultValue(result.getObject("data_default"));
                String pkey_name = result.getString("PK_NAME");
                cp.setPrimaryKey(pkey_name != null && pkey_name.length() > 0);
                cp.setType(getJavaTypeFromDBType(cp.getTypeAsDB()));
                cp.setForceAutoValue(result.getString("KEY_SEQ") != null);
                colMap.put(cp.getName(), cp);
            }
        }
        result.close();
        for(Iterator it = colMap.values().iterator(); it.hasNext(); list.add((ColumnProperty)it.next()));
        return list;
    }

    private Class getJavaTypeFromDBType(String type_as_DB)
        throws POQLException
    {
        String upper = type_as_DB.toUpperCase();
        if(typeMap.containsKey(upper))
            return (Class)typeMap.get(upper);
        for(int i = 0; i < typeArray.length; i++)
            if(perl.match(upper, (String)typeArray[i][0]))
                return (Class)typeArray[i][1];

        throw new POQLException("not recoganize db TYPE(HSQL) " + type_as_DB);
    }

    public boolean isExistTable(String table_name)
        throws SQLException
    {
        String sql = "SELECT table_name FROM INFORMATION_SCHEMA.SYSTEM_TABLES WHERE UPPER(TABLE_NAME) = UPPER('" + table_name + "')";
        ResultSet result = statement.executeQuery(sql.toString());
        boolean is_exist = false;
        while(result.next()) 
        {
            int c = 1;
            String table = result.getString(c++);
            if(table != null && table_name != null && table.toUpperCase().equals(table_name.toUpperCase()))
            {
                is_exist = true;
                break;
            }
        }
        result.close();
        return is_exist;
    }

    public void createTable(String table_name, ColumnProperty cp[])
        throws POQLException, SQLException
    {
        if(cp == null || cp.length == 0)
            throw new POQLException("ColumnProperty value is invalid:" + cp);
        StringBuffer sql = new StringBuffer("CREATE TABLE " + table_name + "(");
        ColumnProperty pk_cp = cp[0];
        for(int i = 0; i < cp.length; i++) {
            sql.append(getJava2DBType(cp[i]) + ", ");
            if (cp[i].isPrimaryKey()) {
            	pk_cp = cp[i];
            }
        }

        sql.append("constraint pk_" + table_name + " primary key (" + pk_cp.getName() + ") ");
        sql.append(" )");
        statement.executeUpdate(sql.toString());
    }

    private String getJava2DBType(ColumnProperty cp)
        throws POQLException
    {
        StringBuffer sql = new StringBuffer(cp.getName());
        
        // enum 型チェック
        if (cp.getType().isEnum()) {
        	// String型として扱う
	        sql.append(" VARCHAR ");
        } else {
	        if(!java2dbTypeMap.containsKey(cp.getType()))
	            throw new POQLException("cannot get type:" + cp.getType() + "(java 2 db) [" + "HSQL" + "]");
	        sql.append(" " + (String)java2dbTypeMap.get(cp.getType()));
        }
        if(cp.getSize() > 0)
            sql.append("(" + cp.getSize() + ")");
        if(cp.getDefaultValue() != null && cp.getDefaultValue().toString().length() > 0)
            sql.append(" DEFAULT " + cp.getDefaultValue());
        
        // autonumber
        if (cp.isForceAutoValue()) {
        	sql.append(" GENERATED BY DEFAULT AS IDENTITY (START WITH 1) ");
        }
        if(!cp.isNullable())
            sql.append(" not null");
        sql.append(" ");
        return sql.toString();
    }

    public String getSelectSQL(String tableName, ArrayList bpList, String where, String groupby, String orderby)
    {
        StringBuffer sql = null;
        if(groupby != null && groupby.trim().length() > 0)
            sql = new StringBuffer("SELECT " + groupby + " FROM " + tableName);
        else
            sql = new StringBuffer("SELECT * FROM " + tableName);
        if(where != null && where.trim().length() > 0)
            sql.append(" WHERE " + where.trim());
        if(groupby != null && groupby.trim().length() > 0)
            sql.append(" GROUP BY " + groupby.trim());
        if(orderby != null && orderby.trim().length() > 0)
            sql.append(" ORDER BY " + orderby.trim());
        return sql.toString();
    }

    public String getSQL_NOW()
    {
        return " NOW ";
    }

    public String getSQL_NOW(String column_type)
    {
        return getSQL_NOW();
    }

	public String formatDateVal(java.util.Date date, String column_type) {
        return "'" + POQLUtil.formatDateTime(date) + "'";
//        if(column_type.equalsIgnoreCase("DATE"))
//            return "TO_DATE('" + POQLUtil.formatDateTime(date) + "','YYYY-MM-DD HH24:MI:SS')";
//        else
//            return "'" + POQLUtil.formatDateTime(date) + "'";
	}
	
    private static final String DB_TYPE = "HSQL";
    private static Hashtable db2javaTypeMap;
    private static Object db2javaMap[][];
    private static Object java2dbMap[][];
    private static Hashtable java2dbTypeMap;
    private static Perl5Util perl = new Perl5Util();
    private static Hashtable typeMap;
    private static Object typeArray[][];

    static 
    {
        db2javaTypeMap = new Hashtable();
        db2javaMap = (new Object[][] {
            new Object[] {
                "INTEGER", java.lang.Integer.class
            }, new Object[] {
                "INT", java.lang.Integer.class
            }, new Object[] {
                "DOUBLE", java.lang.Double.class
            }, new Object[] {
                "DOUBLE PRECISION", java.lang.Double.class
            }, new Object[] {
                "FLOAT", java.lang.Double.class
            }, new Object[] {
                "VARCHAR", java.lang.String.class
            }, new Object[] {
                "VARCHAR_IGNORECASE", java.lang.String.class
            }, new Object[] {
                "CHAR", java.lang.String.class
            }, new Object[] {
                "CHARACTER", java.lang.String.class
            }, new Object[] {
                "LONGVARCHAR", java.lang.String.class
            }, new Object[] {
                "DATE", java.sql.Date.class
            }, new Object[] {
                "TIME", java.sql.Time.class
            }, new Object[] {
                "TIMESTAMP", java.sql.Timestamp.class
            }, new Object[] {
                "DATETIME", java.sql.Timestamp.class
            }, new Object[] {
                "DECIMAL", java.math.BigDecimal.class
            }, new Object[] {
                "NUMERIC", java.math.BigDecimal.class
            }, new Object[] {
                "BOOLEAN", java.lang.Boolean.class
            }, new Object[] {
                "BIT", java.lang.Boolean.class
            }, new Object[] {
                "TINYINT", java.lang.Byte.class
            }, new Object[] {
                "SMALLINT", java.lang.Short.class
            }, new Object[] {
                "BIGINT", java.lang.Long.class
            }, new Object[] {
                "REAL", java.lang.Double.class
            }, new Object[] {
                "BINARY", byte[].class
            }, new Object[] {
                "LONGVARBINARY", byte[].class
            }, new Object[] {
                "OTHER", java.lang.Object.class
            }, new Object[] {
                "OBJECT", java.lang.Object.class
            }
        });
        java2dbMap = (new Object[][] {
            new Object[] {
                java.lang.Byte.class, "TINYINT"
            }, new Object[] {
                java.lang.Short.class, "TINYINT"
            }, new Object[] {
                java.lang.Character.class, "TINYINT"
            }, new Object[] {
                    java.lang.Integer.class, "INT"
            }, new Object[] {
                    int.class, "INT"
            }, new Object[] {
                java.lang.Long.class, "BIGINT"
            }, new Object[] {
                    java.lang.Double.class, "DOUBLE PRECISION"
            }, new Object[] {
                    double.class, "DOUBLE PRECISION"
            }, new Object[] {
                java.lang.String.class, "VARCHAR"
            }, new Object[] {
                    java.sql.Timestamp.class, "TIMESTAMP"
            }, new Object[] {
                    java.sql.Date.class, "DATE"
            }, new Object[] {
                java.util.Date.class, "DATE"
            }, new Object[] {
                boolean.class, "BOOLEAN"
            }
        });
        java2dbTypeMap = new Hashtable();
        for(int i = 0; i < db2javaMap.length; i++)
            db2javaTypeMap.put(db2javaMap[i][0], db2javaMap[i][1]);

        for(int i = 0; i < java2dbMap.length; i++)
            java2dbTypeMap.put(java2dbMap[i][0], java2dbMap[i][1]);

        typeMap = new Hashtable();
        typeArray = (new Object[][] {
            new Object[] {
                "CHAR\\([0-9]+\\)", java.lang.String.class
            }, new Object[] {
                "VARCHAR\\([0-9]+\\)", java.lang.String.class
            }, new Object[] {
                "DOUBLE\\([0-9]+\\)", java.lang.Double.class
            }, new Object[] {
                "NUMERIC\\([0-9]+\\)", java.math.BigDecimal.class
            }, new Object[] {
                "DECIMAL\\([0-9]+,[0-9]+\\)", java.math.BigDecimal.class
            }, new Object[] {
                "TIMESTAMP\\([0-9]+\\)", java.sql.Timestamp.class
            }, new Object[] {
                "INTEGER", java.lang.Integer.class
            }, new Object[] {
                "INT", java.lang.Integer.class
            }, new Object[] {
                "DOUBLE", java.lang.Double.class
            }, new Object[] {
                "DOUBLE PRECISION", java.lang.Double.class
            }, new Object[] {
                "FLOAT", java.lang.Double.class
            }, new Object[] {
                "VARCHAR", java.lang.String.class
            }, new Object[] {
                "VARCHAR_IGNORECASE", java.lang.String.class
            }, new Object[] {
                "CHAR", java.lang.String.class
            }, new Object[] {
                "CHARACTER", java.lang.String.class
            }, new Object[] {
                "LONGVARCHAR", java.lang.String.class
            }, new Object[] {
                "DATE", java.sql.Date.class
            }, new Object[] {
                "TIME", java.sql.Time.class
            }, new Object[] {
                "TIMESTAMP", java.sql.Timestamp.class
            }, new Object[] {
                "DATETIME", java.sql.Timestamp.class
            }, new Object[] {
                "DECIMAL", java.math.BigDecimal.class
            }, new Object[] {
                "NUMERIC", java.math.BigDecimal.class
            }, new Object[] {
                "BOOLEAN", java.lang.Boolean.class
            }, new Object[] {
                "BIT", java.lang.Boolean.class
            }, new Object[] {
                "TINYINT", java.lang.Byte.class
            }, new Object[] {
                "SMALLINT", java.lang.Short.class
            }, new Object[] {
                "BIGINT", java.lang.Long.class
            }, new Object[] {
                "REAL", java.lang.Double.class
            }, new Object[] {
                "BINARY", byte[].class
            }, new Object[] {
                "LONGVARBINARY", byte[].class
            }, new Object[] {
                "OTHER", java.lang.Object.class
            }, new Object[] {
                "OBJECT", java.lang.Object.class
            }
        });
        for(int i = 0; i < typeArray.length; i++)
            typeMap.put(typeArray[i][0], typeArray[i][1]);

    }

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.vendor.DBDependQLStatement#getSysSelectTableAllSql()
	 */
	public String getSysSelectTableAllSql() {
		return 
			"SELECT table_name tableName FROM INFORMATION_SCHEMA.SYSTEM_TABLES ORDER BY tableName";
	}

	public String getSysSelectTableBySchemaSql(String schema) {
		return 
		"SELECT TABLE_NAME tableName, TABLE_SCHEM schema FROM INFORMATION_SCHEMA.SYSTEM_TABLES WHERE TABLE_TYPE='TABLE'";
		// "SELECT TABLE_NAME tableName, TABLE_SCHEM schema FROM INFORMATION_SCHEMA.SYSTEM_TABLES WHERE UCASE(TABLE_SCHEM) = UCASE('" + schema + "') ORDER BY schema,tableName";
	}
	
		
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.vendor.DBDependQLStatement#getSysSelectSchemaAllSql()
	 */
	public String getSysSelectSchemaAllSql() {
		return 
		"SET SCHEMA INFORMATION_SCHEMA;SELECT TABLE_SCHEM schemaName FROM INFORMATION_SCHEMA.SYSTEM_SCHEMAS ORDER BY schemaName";
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.vendor.DBDependQLStatement#getGeneratedKey(jp.co.powerbeans.powerql.POQLPreparedStatement)
	 */
	public Object getGeneratedKey(POQLPreparedStatement st) throws SQLException {
		// ダミー実装.
		ResultSet key_rset = st.getGeneratedKeys();
		if (key_rset == null) {
			return Integer.valueOf(0);
		}
		return key_rset.getInt(1);
	}

}
