package jp.co.powerbeans.powerql.vendor;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.co.powerbeans.powerql.BeanProperty;
import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.Log;
import jp.co.powerbeans.powerql.POQLUtil;


/**
 * <p>タイトル: DBDependQLStatementSupport</p>
 * <p>説明: DBDependQLStatement の 共通処理実装抽象クラス。</p>
 * 
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/10</p>
 * @author 門田明彦
 * @version $Revision: 1.4 $
 */
abstract public class DBDependQLStatementSupport implements DBDependQLStatement {

	/** Connection */
	protected Connection connection;
	
	/** Statement */
	protected Statement statement;

	/** POQLManager (include vendor type) */
	protected POQLManager manager;
	
	/**
	 * コンストラクタ
	 */
	public DBDependQLStatementSupport() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.vendor.DBDependQLStatement#setConnection(java.sql.Connection)
	 */
	public void setConnection(Connection connection) {
		this.connection = connection;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.vendor.DBDependQLStatement#setManager(jp.co.powerbeans.powerql.POQLManager)
	 */
	public void setManager(POQLManager manager) {
		this.manager = manager;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.vendor.DBDependQLStatement#setStatement(java.sql.Statement)
	 */
	public void setStatement(Statement statement) {
		this.statement = statement;
	}

    /**
     * 実装クラスを返す
     * @param blob_class Blob実装クラスパス
     * @return Blob実装ベンダークラス。取得できない場合はnull
     */
    public Class getBlobClass(String blob_class) { 
        try {
            Class c = Class.forName(blob_class);
            if (!c.isAssignableFrom(Blob.class)) {
                Log.println("can't assignable from PoqlBlob Class:" + blob_class);
            }
            return c;
        } catch (ClassNotFoundException e) {
            Log.println("can't find PoqlBlob Class:" + blob_class);
//            e.printStackTrace();
        }
        return null;
    }

    /**
     * 日付をカラムタイプに応じてフォーマットして返す。
     * DB2,MySQL,PGSQL用
     * @param date 日付
     * @param column_type DBカラム型
     * @return フォーマットした文字列
     */
    protected String formatDateVal_std(Date date, String column_type) {

        if (column_type.equalsIgnoreCase("TIME")) {
            return "'" + POQLUtil.formatTime(date) + "'";

        } else if (column_type.equalsIgnoreCase("DATETIME")) {
            return "'" + POQLUtil.formatDateTime(date) + "'";

        } else if (column_type.equalsIgnoreCase("DATE")) {
            return "'" + POQLUtil.formatDate(date) + "'";

        } else {
            // 未対応のカラム型. とりあえず DateTimeにする
            return "'" + POQLUtil.formatDateTime(date) + "'";
        }
    }

    /**
     * BeanProlertyのリストからselect句の全フィールド文字列を取得
     * @param bp_list BeanPropertyのリスト
     * @return select 句のフィールド文字列
     */
    protected String getSelectFields(List bp_list) {
        StringBuffer sql = new StringBuffer();
        int c = 0;
        for (Iterator bpit = bp_list.iterator(); bpit.hasNext();) {
            // Property
            BeanProperty bp = (BeanProperty) bpit.next();
            
            // SQLに追加
            if (c > 0) {
                sql.append(",");
            }
            sql.append(bp.getName());
            c++;
        }
        return sql.toString();
    }
    
    /* (non-Javadoc)
     * @see jp.co.powerbeans.powerql.vendor.DBDependQLStatement#escape(java.lang.String)
     */
    public String escape(String sql) {
    	return sql;
    }
}
