#ifndef S_FORMAT_HANDLER_H
#define S_FORMAT_HANDLER_H

/*!
  \file
  \brief S-Format ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


class SFormatHandler {
  SFormatHandler(const SFormatHandler& rhs);
  SFormatHandler& operator = (const SFormatHandler& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  typedef struct {
    char type;
    char data_size;
    unsigned long address;
    char byte_data[49];
  } srec_t;

  typedef bool (*LineHandler) (srec_t* srec, void* args);

  explicit SFormatHandler(const char* sformatFile);
  ~SFormatHandler(void);

  const char* what(void);

  static bool parseLine(srec_t* srec, const char* line);
  bool eachLines(LineHandler callback, void* args);
  size_t getLinesNum(void);
  unsigned long getStartAddress(void);
};

#endif /* !S_FORMAT_HANDLER_H */
