#!/usr/bin/perl
#==========================================================================#
#  B.Forum logupdate.pl Ver.1.01                                         #
#  Hiroaki,Sakuma (sakuma@beetas.org)                                    #
#                                                                          #
# Υץꥱϥץ󥽡Ǥ.                          #
# ̵ǻѤ뤳ȤǤޤ.                                            #
# ʤ, ܺ٤ʻѾ/ǿˤĤƤϲȤ.           #
# http://www.beetas.org/                                                   #
#                                                                          #
# ------------------------------------------------------------------------ #
# Copyright 2002 Hiroaki,Sakuma All Rights Reserved.                       #
# Copyright 2002 BEETAS.org All Rights Reserved.                           #
#                                                                          #
#==========================================================================#
package logupdate;
$version = '1.01-2';
$revision = '1.01.0002';
$rcfile = '.bforumrc';

unshift (@INC,'.');

use Bforum;

&main;

sub main {

	$start = (times)[0];

	&decode;

	$in{'h'} ||= $in{'help'};
	$in{'d'} ||= $in{'delete'};
	$in{'v'} ||= $in{'version'};

	$account = 0;
	$dir = 0;
	$files = 0;
	$compress = 0;

	&Bforum::setting(\%SET,"./$rcfile","$ENV{'HOME'}/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});

	if ($in{'v'}) {
		&version;
		exit;
	} elsif ($in{'h'} || !%in) {
		&version;
		&usage;
	}

	&version;
	if ($in{'id'}) {
		&reflexive("$SET{'USER_DIR'}/$in{'id'}");
	} else {
		&reflexive("$SET{'USER_DIR'}");
	}
	&finish;

}

sub usage {
	$print = <<"END";
Ȥ:

ޤ, bforum.cgiBForum.pmΤǥ쥯ȥذưޤ.

\$ ./logupdate.pl [-ץ] [оݥ]

--charset="." åʸɤꤷޤ. ɸeucǤ.
              ǤΤ'euc','sjis','jis'Ǥ.

:

\$ cd cgi-bin
\$ ./logupdate.pl

\[Win32\]
C:\\web\\cgi-bin\\bforum> logupdate.pl --charset=sjis
END
	print code($print);
	exit;
}

sub version {
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-74s%1s\n","#","  B.Forum logupdate.pl Ver.$version($revision)","#");
	printf code("%1s%-74s%1s\n","#","  Hiroaki,Sakuma (sakuma\@beetas.org)","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#"," This is free software.","#");
	printf ("%1s%-74s%1s\n","#"," You can use of free.","#");
	printf ("%1s%-74s%1s\n","#"," See the our webpage for more details and news.","#");
	printf ("%1s%-74s%1s\n","#"," http://www.beetas.org/","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s %-72s %1s\n","#",("-" x 72),"#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 Hiroaki,Sakuma All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 BEETAS.org All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	print "\n";
}

sub finish {
	print "\n";
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Time",sprintf("%.2f",((times)[0] - $start)),"sec.","#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Account","$account",undef,"#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	exit;
}

sub comma {
	my ($tmp1);
	my (@tmp2);
	$tmp1 = $_[0];
	if (!$tmp1) { return "0"; }
	while ($tmp1) {
		unshift (@tmp2,substr($tmp1,-3,3,undef));
	}
	return join(',',@tmp2);
}

sub code {
	undef $tmp2;

	@tmp2 = @_;

	if ($in{'charset'}) {
		if (!$init{'code'}) {
			if ($SET{'NKF'}) {
				eval("use $SET{'NKF'}");
			} elsif ($SET{'JCODE'}) {
				require $SET{'JCODE'} || &error;
			}
			$init{'code'} = 1;
		}

		if ($init{'code'}) {

			$tmp1 = $in{'charset'};

			foreach (@tmp2) {
				if ($_ =~ /\w/) {
					if ($SET{'NKF'}) {
						$$tmp1 = NKF::nkf("--$tmp1",$_);
					} elsif ($SET{'JCODE'}) {
						jcode::convert(\$_,$tmp1,'euc','z');
					}
				}
			}

		}

	}

	return @tmp2;

}

sub reflexive {
	local ($open) = $_[0];

	local (@files,$path);
	opendir (DIR,$open);
	@files = readdir(DIR);
	closedir (DIR);
	foreach $path (@files) {
		if ($path eq '.' || $path eq '..') { next; }
		if ($path eq 'index') {
			$in{'id'} = $open;
			$in{'id'} =~ s/^$SET{'USER_DIR'}\///g;
			&init;
		}
		$path = "$open/$path";
		if (-d $path) { &reflexive($path); }
	}
}

sub init {

	&Bforum::setting(\%SET,"$SET{'USER_DIR'}/$in{'id'}/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});

	if (-f "$SET{'USER_DIR'}/$in{'id'}/index") {
		printf ("%-76s","=>$in{'id'}");
		if ($SET{'ARCHIVE_DO'} ne 'N') {
#			eval ("use $SET{'ARCHIVE'}");
			eval ("use Archive::Tar");
			if ($@) { return; }
		} else {
			return;
		}

		if ($tmp1 = &mkarchive("$SET{'USER_DIR'}/$in{'id'}")) {
			print "Error:$tmp1\n";
		} else {
			print ("\b" x 76);
			printf ("=>$in{'id'}\[Complete\]%-" . (76 -(length($in{'id'})) - 12) . "s\n",undef);
			if ($SET{'COMPRESS_DO'} ne 'N') {
				$compress++;
			}
		}

	}

}

sub mkarchive {

	my ($tmp1,$tmp2,$tmp3);
	my (@tmp);

	if(-d $_[0] && $in{'b'}) {
		$account++;
		&archive($_[0],undef,'BF');
	} elsif (-f "$_[0]/index") {
		$account++;
		$tmp1 = @tmp = &Bforum::_open('file',"$_[0]/index");
		undef $tmp2;
		foreach (@tmp) {
			chomp $_;
			$in{'t'} = $_;
			if (-f "$_[0]/$in{'t'}.bfa") {

				$tmp3 = Archive::Tar->new();
				$tmp3->read("$_[0]/$in{'t'}.bfa",1);
				unlink ("$_[0]/$in{'t'}.bfa");
				if (!-d "$_[0]/$in{'t'}") {
					mkdir ("$_[0]/$in{'t'}",0777);
				}
				foreach ($tmp3->list_files()) {
					if ($_ =~ /^(last)$/) { next; }
					if (!-f "$_[0]/$in{'t'}/$_") {
						open (FILE,">$_[0]/$in{'t'}/$_");
						binmode (FILE);
						print FILE $tmp3->get_content($_);
						close (FILE);
					}
				}
				if(-d "$_[0]/$in{'t'}") { &archive($_[0],"/$in{'t'}","$in{'t'}"); }

			}

			$tmp2++;
			print ("\b" x 76);
			printf ("=>$in{'id'}\[%s\]#%-" . (76 -(length("$in{'id'}$_")) - 10) . "s#%3d\%", "$_",('=' x (int($tmp2 * (76 - (length("$in{'id'}$_")) - 10) / $tmp1))),(int(100 * $tmp2 / $tmp1)));
		}
	}


	return;
}

sub archive {
	my ($tmp1,$tmp2,$tmp3,$tmp4,$tmp5);
	my (@tmp);

	opendir (DIR,"$_[0]$_[1]");
	$tmp1 = @tmp = readdir(DIR);
	undef $tmp4;
	foreach (@tmp) {

		if ($_ eq '.' || $_ eq '..') { next; }

		if ($_[2] eq 'BF') {
			if ($_ !~ /^BF\..+$/) { next; }
			print ("\b" x 76);
			printf ("=>$in{'id'}\[%s\]#%-" . (76 -(length("$in{'id'}$_")) - 10) . "s#%3d\%", "$_",('=' x (int($tmp4 * (76 - (length("$in{'id'}$_")) - 10) / $tmp1))),(int(100 * $tmp4 / $tmp1)));
		}

		if (-f "$_[0]$_[1]/$_" && $_ !~ /\.bfa$/) {

			$f_size += (-s "$_[0]$_[1]/$_");

			$tmp4++;

			open (FILE,"$_[0]$_[1]/$_");
			binmode (FILE);
			$tmp3 = join('',<FILE>);
			close (FILE);
			unlink("$_[0]$_[1]/$_");

			$tmp2 = Archive::Tar->new();
			if ($_ =~ /^(list)$/o) {
				if (-f ("$_[0]/$_[2].0.bfa")) { $tmp2->read(("$_[0]/$_[2].0.bfa"),1) }
				$tmp2->remove($_);
				$tmp2->add_data($_,$tmp3);
				if ($SET{'COMPRESS_DO'} ne 'N') {
					&Bforum::_compress(("$_[0]/$_[2].0.bfa"),$tmp2->write());
				} else {
					$tmp2->write(("$_[0]/$_[2].0.bfa"));
				}
			} elsif ($_ =~ /^\d+$/o) {
				if (-f ("$_[0]/$_[2]." . int ($_ / 10) . ".bfa")) { $tmp2->read(("$_[0]/$_[2]." . int ($_ / 10) . ".bfa"),1) }
				$tmp2->remove($_);
				$tmp2->add_data($_,$tmp3);
				if ($SET{'COMPRESS_DO'} ne 'N') {
					&Bforum::_compress(("$_[0]/$_[2]." . int ($_ / 10) . ".bfa"),$tmp2->write());
				} else {
					$tmp2->write(("$_[0]/$_[2]." . int ($_ / 10) . ".bfa"));
				}
			} else {
				if (-f "$_[0]/$_[2].bfa") { $tmp2->read("$_[0]/$_[2].bfa",1) }
				$tmp2->remove($_);
				$tmp2->add_data($_,$tmp3);
				if ($SET{'COMPRESS_DO'} ne 'N') {
					&Bforum::_compress("$_[0]/$_[2].bfa",$tmp2->write());
				} else {
					$tmp2->write("$_[0]/$_[2].bfa");
				}
			}
			undef $tmp2;
		}
	}

	$dir++;
	$files += $tmp4;

	closedir (DIR);

	$a_size += (-s "$_[0]/$_[2].bfa");

	if ("$_[0]$_[1]" ne "$SET{'USER_DIR'}/$in{'id'}") {
		rmdir("$_[0]$_[1]") || print "\nrmdir $_[0]$_[1] : $!\n";
	}

	return;
}

sub decode {
	my ($buffer);
	if ($ENV{'REQUEST_METHOD'} eq "POST") {
		read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	} else { $buffer = $ENV{'QUERY_STRING'}; }
	if (!$buffer) { $buffer = $ARGV[0]; }
	foreach (@ARGV) {
		if ($_ =~ /^--(\S*)=(\S*)$/) {
			$in{$1} = $2;
		} elsif ($_ =~ /^--(\S*)$/) {
			$in{$1} = 1;
		} elsif ($_ =~ /^-(\S*)$/) {
			foreach (split(//,$1)) {
				$in{$_} = 1;
			}
		} else {
			$in{'id'} = $_;
		}
	}

	undef @_;
}

sub error {
	print "\nError:" . (caller)[2] . '@' . (caller)[1];
	undef @_;
	exit;
}

