#==========================================================================#
#  B.Forum                                                               #
#  SQL RDBMSץ饰 Ver.1.02                                          #
#  Encode = EUC                                                          #
#  Sakuma,Hiroaki ( sakuma@beetas.org )                                  #
#  BEETAS.org ( info@beetas.org )                                        #
#                                                                          #
# Υץꥱϥץ󥽡Ǥ.                          #
# ̵ǻѤ뤳ȤǤޤ.                                            #
# ʤ, ܺ٤ʻѾ/ǿˤĤƤϲȤ.           #
# http://www.beetas.org/                                                   #
#                                                                          #
# ------------------------------------------------------------------------ #
# Copyright 2001-2004 Sakuma,Hiroaki All Rights Reserved.                  #
# Copyright 2001-2004 BEETAS.org All Rights Reserved.                      #
#                                                                          #
#==========================================================================#
package Bforum::Plugin::sql;

$VERSION = "1.02";
@REQUIRE = ("1.02B-1");
@METHOD = ("create","_indexcheck","_open","_write","_diskwrite","sql");

use strict;
use vars qw($VERSION @REQUIRE @METHOD);
use vars qw(%in %SET %TEXT);
use vars qw($head $foot);


## ᥽å

## new
## 󥹥󥹤֤
## $obj = Bforum::Plugin::admin->new(
##    in => \%in,
##    SET => \%SET,
##    TEXT => \%TEXT,
## );
sub new {

	my ($tmp1) = shift;
	my ($class) = ref($tmp1) || $tmp1;
	my ($self) = {};

	$self->{'in'} = {};
	$self->{'SET'} = {};
	$self->{'TEXT'} = {};

	my (%args) = @_;
	foreach (keys %args) {
		$self->{$_} = $args{$_};
	}

	%in = %{$self->{'in'}};
	%SET = %{$self->{'SET'}};
	%TEXT = %{$self->{'TEXT'}};

	bless ($self, $class);

	return $self;

}

## version
## С֤
## $obj->version();
sub version {

	my ($self) = shift;

	my ($version) = "BEETAS.org MySQLץ饰 $VERSION(" . join(",",@REQUIRE) . ")";
	return $version;

}

## require
## ưСΥå
## $obj->require($revision);
sub require {

	my ($self) = shift;
	my ($version,$revision) = @_;
	my ($tmp1) = 0;

	foreach (@REQUIRE) {
		if ($_ =~ /^($version|$revision)$/) {
			$tmp1 = 1;
			last;
		}
	}

	return $tmp1;

}

## args
## 餦
## $obj->args(
##   in => \%in,
##   SET => \%SET,
##   TEXT => \%TEXT,
##   head => \$head,
##   foot => \$foot
## );
sub args {

	my ($self) = shift;

	my (%args) = @_;
	foreach (keys %args) {
		$self->{$_} = $args{$_};
	}

	%in = %{$self->{'in'}};
	%SET = %{$self->{'SET'}};

	return 1;

}



## create
sub create {

	my (%create);

	my ($db_id);
	my ($db,$db_tmp1,$db_tmp2);
	&db_id($db_id);

	if (-d "$SET{'USER_DIR'}/$in{'id'}" && -z "$SET{'USER_DIR'}/$in{'id'}/index") {

		&db_connect($db) || &Bforum::error("$DBI::errstr \[$DBI::err\]");

		$db_tmp1 = "CREATE TABLE $db_id (UNIQUE INDEX (name),name VARCHAR(64) NOT NULL,file BLOB)";
		if (!&db_do($db,\$db_tmp1,\$db_tmp2)) { &Bforum::error("$DBI::errstr \[$DBI::err\]"); }

		&db_finish(\$db_tmp2);

		return;

	} else {

		&about($db);

	}

}

sub sql {

	my($tmp1,$tmp2);
	my(@tmp3);

	my($db_id);
	my($db,$db_tmp1,$db_tmp2);
	my(%db_tmp3);
	&db_id($db_id);

	if (&check) {

		if ($in{'id'}) {

			if ($in{'convert'} eq "s2b" && &Bforum::_open(undef,"$SET{'USER_DIR'}/$in{'id'}/index") eq "SQL") {

				&db_connect($db) || &Bforum::error("$DBI::errstr \[$DBI::err\]");

				$db_tmp1 = "SELECT * FROM $db_id";
				if(defined &db_do($db,\$db_tmp1,\$db_tmp2) && $db_tmp2->rows) {

					warn($db_tmp2->rows);
					foreach (1 .. $db_tmp2->rows) {

						$tmp1 = $db_tmp2->fetchrow_hashref;
						if (defined $tmp1) {
							&Bforum::_write($tmp1->{'name'},$tmp1->{'file'});
						}

					}

				}

				&db_finish(\$db_tmp2);

				$db_tmp1 = "DROP TABLE $db_id";
				if (!&db_do($db,\$db_tmp1,\$db_tmp2)) { &Bforum::error("$DBI::errstr \[$DBI::err\]"); }

				&db_finish(\$db_tmp2);

				return &Bforum::_bfopen("BF.plugin.sql.complete");

			} elsif ($in{'convert'} eq "b2s" && &Bforum::_open(undef,"$SET{'USER_DIR'}/$in{'id'}/index") ne "SQL") {

				&db_connect($db) || &Bforum::error("$DBI::errstr \[$DBI::err\]");

				$db_tmp1 = "CREATE TABLE $db_id (UNIQUE INDEX (name),name VARCHAR(64) NOT NULL,file BLOB)";
				if (!&db_do($db,\$db_tmp1,\$db_tmp2)) { &Bforum::error("$DBI::errstr \[$DBI::err\]"); }

				&db_finish(\$db_tmp2);

				foreach (&Bforum::_open('file',"$SET{'USER_DIR'}/$in{'id'}/index")) {

					$tmp2 = $_;
					chomp($tmp2);

					if (&Bforum::_open(undef,"$SET{'USER_DIR'}/$in{'id'}/$tmp2/.passwd")) { push(@tmp3,"$SET{'USER_DIR'}/$in{'id'}/$tmp2/.passwd"); }
					if (&Bforum::_open(undef,"$SET{'USER_DIR'}/$in{'id'}/$tmp2/count")) { push(@tmp3,"$SET{'USER_DIR'}/$in{'id'}/$tmp2/count"); }

					foreach (1 .. &Bforum::_open('line',"$SET{'USER_DIR'}/$in{'id'}/$tmp2/list") + 1) {
						push(@tmp3,"$SET{'USER_DIR'}/$in{'id'}/$tmp2/$_");
					}

				}

				push(@tmp3,"$SET{'USER_DIR'}/$in{'id'}/index");
				push(@tmp3,"$SET{'USER_DIR'}/$in{'id'}/index.create");
				push(@tmp3,"$SET{'USER_DIR'}/$in{'id'}/index.posts");
				push(@tmp3,"$SET{'USER_DIR'}/$in{'id'}/status");

				foreach (@tmp3) {

					$db_tmp3{'1'} = $_;
					$db_tmp3{'2'} = &Bforum::_open(undef,$_);

					$db_tmp1 = "INSERT INTO $db_id (name,file) VALUES (?,?)";
					if (!&db_do($db,\$db_tmp1,\$db_tmp2,\%db_tmp3)) { &Bforum::error("$DBI::errstr \[$DBI::err\]"); }

					&db_finish(\$db_tmp2);

				}

				foreach (&Bforum::_open('file',"$SET{'USER_DIR'}/$in{'id'}/index")) {

					chomp($_);

					$tmp2 = 0;

					while (1) {

						if (-f "$SET{'USER_DIR'}/$in{'id'}/$_.$tmp1.bfa") {
							unlink ("$SET{'USER_DIR'}/$in{'id'}/$_.$tmp1.bfa");
						} else {
							last;
						}

						$tmp1++;

					}

					unlink ("$SET{'USER_DIR'}/$in{'id'}/$_.bfa");
					&rmdir("$SET{'USER_DIR'}/$in{'id'}/$_");

				}

				unlink("$SET{'USER_DIR'}/$in{'id'}/index");
				unlink("$SET{'USER_DIR'}/$in{'id'}/index.create");
				unlink("$SET{'USER_DIR'}/$in{'id'}/index.posts");
				unlink("$SET{'USER_DIR'}/$in{'id'}/status");

				&Bforum::_write("$SET{'USER_DIR'}/$in{'id'}/index","SQL");

				return &Bforum::_bfopen("BF.plugin.sql.complete");

			} else {

				if (&Bforum::_open(undef,"$SET{'USER_DIR'}/$in{'id'}/index") eq "SQL") {
					return &Bforum::_bfopen("BF.plugin.sql.s2b");
				} else {
					return &Bforum::_bfopen("BF.plugin.sql.b2s");
				}

			}

		} else {

			return "Require id";

		}

	} else {

		return &Bforum::_bfopen("BF.plugin.sql.form");

	}

}

sub _indexcheck {

	my ($self) = shift;

	my ($db_id);
	my ($db,$db_tmp1,$db_tmp2);
	my ($tmp1);

	&db_id($db_id);

	&db_connect($db) || &Bforum::error("$DBI::errstr \[$DBI::err\]");

	$db_tmp1 = "SELECT file FROM $db_id WHERE name=\"$SET{'USER_DIR'}/$_[0]/$_[1]/1\"";
	if (defined &db_do($db,\$db_tmp1,\$db_tmp2) && $db_tmp2->rows) {
		$tmp1 = "";
	} else {
		undef $tmp1;
	}

	return $tmp1;

}

## _open
sub _open {

	my ($self) = shift;

	my ($db_id);
	my ($db,$db_tmp1,$db_tmp2);
	my ($tmp1,$tmp2);

	&db_id($db_id);

	shift(@_);

	&db_connect($db) || &Bforum::error("$DBI::errstr \[$DBI::err\]");

	foreach (@_) {

		$tmp1 = $_;
		$tmp1 =~ s/\/+/\//go;
		$tmp1 =~ s/;.*$//go;

		if (defined @{$Bforum::cache->{'file'}->{$tmp1}}) {
			last;
		} else {

			$db_tmp1 = "SELECT file FROM $db_id WHERE name=\"$tmp1\"";
			if(defined &db_do($db,\$db_tmp1,\$db_tmp2) && $db_tmp2->rows) {

#				$tmp2 = $db_tmp2->fetchrow_hashref;
#				if (defined $tmp2) {
#					@{$Bforum::cache->{'file'}->{$tmp1}} = ($tmp2->{'file'});
#				}
				@{$Bforum::cache->{'file'}->{$tmp1}} = split(/\n/,$db_tmp2->fetchrow_array);
				map { $_ .= "\n"; } @{$Bforum::cache->{'file'}->{$tmp1}};
				&db_finish(\$db_tmp2);
				last;

			}

			&db_finish(\$db_tmp2);

		}

	}

	return;

}

sub _write {

	my ($self) = shift;

	my ($db_id);
	my ($db,$db_tmp1,$db_tmp2);
	my (%db_tmp3);
	my ($tmp1,$tmp2,$tmp3);

	&db_id($db_id);

	$tmp1 = shift(@_);

	open(FILE,"$SET{'USER_DIR'}/$in{'id'}/index");
	binmode(FILE);
	$tmp2 = <FILE>;
	close(FILE);

	if ($tmp2 eq "SQL" || -z "$SET{'USER_DIR'}/$in{'id'}/index") {

		&db_connect($db) || &Bforum::error("$DBI::errstr \[$DBI::err\]");

		@{$Bforum::cache->{'file'}->{$tmp1}} = @_;

		$db_tmp1 = "DELETE FROM $db_id WHERE name=\"$tmp1\"";
		&db_do($db,\$db_tmp1,\$db_tmp2);

		$db_tmp3{'1'} = $tmp1;
		$db_tmp3{'2'} = join("",@_);

		$db_tmp1 = "INSERT INTO $db_id (name,file) VALUES (?,?)";
		if (defined &db_do($db,\$db_tmp1,\$db_tmp2,\%db_tmp3)) {
			$tmp3 = "";
		} else {
			undef $tmp3;
		}

		&db_finish(\$db_tmp2);

		return $tmp3;

	} else {

		return;

	}

}

sub _diskwrite {

	if (defined @{$Bforum::cache->{'file'}->{"$SET{'USER_DIR'}/$in{'id'}/index"}} && -z "$SET{'USER_DIR'}/$in{'id'}/index") {
		&Bforum::_write("$SET{'USER_DIR'}/$in{'id'}/index","SQL");
	}

	if (defined @{$Bforum::cache->{'file'}->{"$SET{'USER_DIR'}/$in{'id'}/last"}}) {
		&Bforum::_write("$SET{'USER_DIR'}/$in{'id'}/last",&Bforum::_open(undef,"$SET{'USER_DIR'}/$in{'id'}/last"));
	}

	return;

}

sub check {

	if ($in{'password'} && !&Bforum::_use("MD5") && MD5->hexhash($in{'password'}) eq &Bforum::_open(undef,"$SET{'USER_DIR'}/.passwd")) {
		return 1;
	} else {
		return;
	}

}

sub rmdir {

	my (@tmp1);

	if (-d $_[0]) {
		opendir (DIR,$_[0]);
		@tmp1 = readdir (DIR);
		closedir (DIR);
		foreach (@tmp1) {
			if ($_ =~ /^\.\.?$/) { next; }
			if (-d "$_[0]/$_") {
				&rmdir("$_[0]/$_");
			} else {
				unlink("$_[0]/$_");
			}
		}
		rmdir($_[0]);
	}

}

sub db_connect {

	if ($Bforum::cache->{'db'}) {

		return $_[0] = $Bforum::cache->{'db'};

	} else {

		if (!&Bforum::_use("DBI")) {

			foreach (2) {
				$Bforum::cache->{'db'} = $_[0] = DBI->connect($SET{'DATABASE'},$SET{'DBNAME'},$SET{'DBPASSWORD'},{
					PrintError => 1,
					RaiseError => 0,
					AutoCommit => 1,
				}) || exec($SET{'DAEMON'});
				## Debug
				#DBI->trace(1);

				if ($Bforum::cache->{'db'}) { last; }

			}

			return $_[0];

		} else {

			return;

		}

	}

}

sub db_do {

	${$_[1]} =~ s/\$in{'(.*?)'}/'$in{$1}'/go;
	${$_[2]} = $_[0]->prepare(${$_[1]});
	foreach (keys %{$_[3]}) {
		${$_[2]}->bind_param($_,${$_[3]}{$_});
	}
	${$_[2]}->execute;
	if (${$_[2]}->err) {
		return;
	} else {
		return ${$_[2]};
	}

}

sub db_finish {
	foreach (@_) {
		${$_[0]}->finish;
	}
}

sub db_disconnect {
	$_[0]->disconnect;
}

sub db_id {

	$_[0] = $in{'id'};
	$_[0] =~ s/[^\w]/_/g;

}

sub about {
	if ($_[0]) { &db_disconnect($_[0]); }
	close (NULL);
	&Bforum::about((caller)[2] . '@' . &version);
}



1;


