/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.model;

/**
 * ワード数のためのモデル・クラス。
 */
public class WordCountModel extends AbstractStatModel {
    /**
     * フィールド: [wordCount]。
     */
    private int fWordCount;

    /**
     * フィールド [wordCount] の値を設定します。
     *
     * @param argWordCount フィールド[wordCount]に設定する値。
     */
    public void setWordCount(final int argWordCount) {
        fWordCount = argWordCount;
    }

    /**
     * フィールド [wordCount] の値を取得します。
     *
     * @return フィールド[wordCount]から取得した値。
     */
    public int getWordCount() {
        return fWordCount;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.stat.model.WordCountModel[");
        buf.append("wordCount=" + fWordCount);
        buf.append("]");
        return buf.toString();
    }
}
