/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.views.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 用語対訳集ヒット率ビューのためのメッセージ。
 *
 * リソースバンドル定義: [GlossaryHitRateViewMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class GlossaryHitRateViewMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * GlossaryHitRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[GlossaryHitRateViewMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public GlossaryHitRateViewMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/GlossaryHitRateViewMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * GlossaryHitRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[GlossaryHitRateViewMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public GlossaryHitRateViewMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/GlossaryHitRateViewMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * GlossaryHitRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[GlossaryHitRateViewMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public GlossaryHitRateViewMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/GlossaryHitRateViewMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[GlossaryHitRateViewMessages], key[resource]
     *
     * [Resource] (en)<br>
     * [リソース] (ja)<br>
     *
     * @return key[resource]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getResource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Resource";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("resource");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[GlossaryHitRateViewMessages], key[more_than_75]
     *
     * [&gt;= 75%] (en)<br>
     * [&gt;= 75%] (ja)<br>
     *
     * @return key[more_than_75]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMoreThan75() {
        // 初期値として定義書の値を利用します。
        String strFormat = ">= 75%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("more_than_75");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[GlossaryHitRateViewMessages], key[more_than_50]
     *
     * [&gt;= 50%] (en)<br>
     * [&gt;= 50%] (ja)<br>
     *
     * @return key[more_than_50]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMoreThan50() {
        // 初期値として定義書の値を利用します。
        String strFormat = ">= 50%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("more_than_50");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[GlossaryHitRateViewMessages], key[more_than_25]
     *
     * [&gt;= 25%] (en)<br>
     * [&gt;= 25%] (ja)<br>
     *
     * @return key[more_than_25]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMoreThan25() {
        // 初期値として定義書の値を利用します。
        String strFormat = ">= 25%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("more_than_25");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[GlossaryHitRateViewMessages], key[less_than_25]
     *
     * [&lt; 25%] (en)<br>
     * [&lt; 25%] (ja)<br>
     *
     * @return key[less_than_25]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLessThan25() {
        // 初期値として定義書の値を利用します。
        String strFormat = "< 25%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("less_than_25");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
