/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.views.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳率ビューのためのメッセージ。
 *
 * リソースバンドル定義: [TranslationRateViewMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class TranslationRateViewMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * TranslationRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationRateViewMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public TranslationRateViewMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/TranslationRateViewMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationRateViewMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public TranslationRateViewMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/TranslationRateViewMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationRateViewMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public TranslationRateViewMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/TranslationRateViewMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[TranslationRateViewMessages], key[resource]
     *
     * [Resource] (en)<br>
     * [リソース] (ja)<br>
     *
     * @return key[resource]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getResource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Resource";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("resource");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[trans_unit]
     *
     * [Translation Unit] (en)<br>
     * [翻訳単位] (ja)<br>
     *
     * @return key[trans_unit]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTransUnit() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Unit";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("trans_unit");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[un_translate]
     *
     * [Non-Translatable] (en)<br>
     * [翻訳対象外] (ja)<br>
     *
     * @return key[un_translate]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getUnTranslate() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Non-Translatable";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("un_translate");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[un_translate_rate]
     *
     * [Non-Translatable Rate] (en)<br>
     * [翻訳対象外率] (ja)<br>
     *
     * @return key[un_translate_rate]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getUnTranslateRate() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Non-Translatable Rate";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("un_translate_rate");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[not_translated]
     *
     * [Untranslated] (en)<br>
     * [未翻訳] (ja)<br>
     *
     * @return key[not_translated]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getNotTranslated() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Untranslated";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("not_translated");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[not_translated_rate]
     *
     * [Untranslated Rate] (en)<br>
     * [未翻訳率] (ja)<br>
     *
     * @return key[not_translated_rate]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getNotTranslatedRate() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Untranslated Rate";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("not_translated_rate");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[translating]
     *
     * [Translating] (en)<br>
     * [翻訳中] (ja)<br>
     *
     * @return key[translating]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTranslating() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translating";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("translating");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[translating_rate]
     *
     * [Translating Rate] (en)<br>
     * [翻訳中率] (ja)<br>
     *
     * @return key[translating_rate]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTranslatingRate() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translating Rate";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("translating_rate");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[translated]
     *
     * [Translated] (en)<br>
     * [翻訳済] (ja)<br>
     *
     * @return key[translated]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTranslated() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translated";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("translated");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationRateViewMessages], key[translated_rate]
     *
     * [Translated Rate] (en)<br>
     * [翻訳済率] (ja)<br>
     *
     * @return key[translated_rate]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTranslatedRate() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translated Rate";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("translated_rate");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
