/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.tm.core;

/**
 * Benten TM (翻訳メモリー) の検索結果をあらわすクラス。
 */
public class BentenTmSearchResult {
    /**
     * 翻訳元の文字列。
     *
     * フィールド: [source]。
     */
    private String fSource;

    /**
     * 翻訳先の文字列。
     *
     * フィールド: [target]。
     */
    private String fTarget;

    /**
     * TM 検索結果の一致品質。
     *
     * フィールド: [match-quality]。
     */
    private String fMatchQuality;

    /**
     * この翻訳の導出元となった TMX 名。なお、TMX 名からはファイル拡張子を除いたものを格納するようにします。
     *
     * フィールド: [origin]。
     */
    private String fOrigin;

    /**
     * フィールド [source] の値を設定します。
     *
     * フィールドの説明: [翻訳元の文字列。]。
     *
     * @param argSource フィールド[source]に設定する値。
     */
    public void setSource(final String argSource) {
        fSource = argSource;
    }

    /**
     * フィールド [source] の値を取得します。
     *
     * フィールドの説明: [翻訳元の文字列。]。
     *
     * @return フィールド[source]から取得した値。
     */
    public String getSource() {
        return fSource;
    }

    /**
     * フィールド [target] の値を設定します。
     *
     * フィールドの説明: [翻訳先の文字列。]。
     *
     * @param argTarget フィールド[target]に設定する値。
     */
    public void setTarget(final String argTarget) {
        fTarget = argTarget;
    }

    /**
     * フィールド [target] の値を取得します。
     *
     * フィールドの説明: [翻訳先の文字列。]。
     *
     * @return フィールド[target]から取得した値。
     */
    public String getTarget() {
        return fTarget;
    }

    /**
     * フィールド [match-quality] の値を設定します。
     *
     * フィールドの説明: [TM 検索結果の一致品質。]。
     *
     * @param argMatchQuality フィールド[match-quality]に設定する値。
     */
    public void setMatchQuality(final String argMatchQuality) {
        fMatchQuality = argMatchQuality;
    }

    /**
     * フィールド [match-quality] の値を取得します。
     *
     * フィールドの説明: [TM 検索結果の一致品質。]。
     *
     * @return フィールド[match-quality]から取得した値。
     */
    public String getMatchQuality() {
        return fMatchQuality;
    }

    /**
     * フィールド [origin] の値を設定します。
     *
     * フィールドの説明: [この翻訳の導出元となった TMX 名。なお、TMX 名からはファイル拡張子を除いたものを格納するようにします。]。
     *
     * @param argOrigin フィールド[origin]に設定する値。
     */
    public void setOrigin(final String argOrigin) {
        fOrigin = argOrigin;
    }

    /**
     * フィールド [origin] の値を取得します。
     *
     * フィールドの説明: [この翻訳の導出元となった TMX 名。なお、TMX 名からはファイル拡張子を除いたものを格納するようにします。]。
     *
     * @return フィールド[origin]から取得した値。
     */
    public String getOrigin() {
        return fOrigin;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.tm.core.BentenTmSearchResult[");
        buf.append("source=" + fSource);
        buf.append(",target=" + fTarget);
        buf.append(",match-quality=" + fMatchQuality);
        buf.append(",origin=" + fOrigin);
        buf.append("]");
        return buf.toString();
    }
}
