/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.data;

import benten.core.AbstractBentenPlugin;

/**
 * Benten TM (翻訳メモリー) のための抽象 TMX 形式データ・プラグイン。
 *
 * <UL>
 * <LI>TMX 形式で格納された TM (翻訳メモリー)・データ を Benten に認識させるための抽象クラスです。
 * <LI>Benten TM データ提供者は、Eclipse 上で TM データを有効にするために、このクラスを継承したクラスを提供する必要があります。
 * </UL>
 * 
 * @author YAMAMOTO Koji
 */
public abstract class AbstractBentenTmDataTmxPlugin extends AbstractBentenPlugin {
	/**
	 * このプラグインの共用インスタンスを取得。
	 * 
	 * <UL>
	 * <LI>getDefault メソッドの代わりになるものです。
	 * <LI>一般的な Eclipse プラグインの流儀とは異なり、非 static メソッドとなっています。
	 * <LI>このメソッドは、クラスが保持する static フィールドの値を暴露します。
	 * </UL>
	 * 
	 * @return このプラグインの共用インスタンス。
	 */
	public abstract AbstractBentenTmDataTmxPlugin getPluginDefault();
}
