/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.core.io.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten コアの Files のためのメッセージ。
 *
 * リソースバンドル定義: [BentenCoreFilesMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenCoreFilesMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenCoreFilesMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreFilesMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenCoreFilesMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/io/messages/BentenCoreFilesMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenCoreFilesMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreFilesMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenCoreFilesMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/io/messages/BentenCoreFilesMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenCoreFilesMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreFilesMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenCoreFilesMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/io/messages/BentenCoreFilesMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenCoreFilesMessages], key[openInputStream_illegalArgument1]
     *
     * [File &quot;{0}&quot; exists, but it is a directory.] (en)<br>
     * [ファイル ''{0}'' は存在しますがディレクトリです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[openInputStream_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getOpenInputStreamIllegalArgument1(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "File \"{0}\" exists, but it is a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("openInputStream_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[openInputStream_illegalArgument2]
     *
     * [Unable to read the file &quot;{0}&quot;.] (en)<br>
     * [ファイル ''{0}'' を読み込むことが出来ません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[openInputStream_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getOpenInputStreamIllegalArgument2(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unable to read the file \"{0}\".";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("openInputStream_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[openInputStream_illegalArgument3]
     *
     * [File &quot;{0}&quot; does not exist.] (en)<br>
     * [ファイル ''{0}'' は存在しません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[openInputStream_illegalArgument3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getOpenInputStreamIllegalArgument3(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "File \"{0}\" does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("openInputStream_illegalArgument3");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[openOutputStream_illegalArgument1]
     *
     * [File &quot;{0}&quot; exists, but it is a directory.] (en)<br>
     * [ファイル ''{0}'' は存在しますがディレクトリです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[openOutputStream_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getOpenOutputStreamIllegalArgument1(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "File \"{0}\" exists, but it is a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("openOutputStream_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[openOutputStream_illegalArgument2]
     *
     * [Unable to write the file &quot;{0}&quot;.] (en)<br>
     * [ファイル ''{0}'' を書き込むことが出来ません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[openOutputStream_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getOpenOutputStreamIllegalArgument2(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unable to write the file \"{0}\".";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("openOutputStream_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[openOutputStream_illegalArgument3]
     *
     * [Unable to create the file &quot;{0}&quot;.] (en)<br>
     * [ファイル ''{0}'' を作成することができません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[openOutputStream_illegalArgument3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getOpenOutputStreamIllegalArgument3(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unable to create the file \"{0}\".";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("openOutputStream_illegalArgument3");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[copyFile_illegalArgument1]
     *
     * [Source must not be null.] (en)<br>
     * [source は null であってはなりません。] (ja)<br>
     *
     * @return key[copyFile_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyFileIllegalArgument1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source must not be null.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("copyFile_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenCoreFilesMessages], key[copyFile_illegalArgument2]
     *
     * [Destination must not be null.] (en)<br>
     * [destination は null であってはなりません。] (ja)<br>
     *
     * @return key[copyFile_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyFileIllegalArgument2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Destination must not be null.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("copyFile_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenCoreFilesMessages], key[copyFile_illegalArgument3]
     *
     * [Source &quot;{0}&quot; does not exist.] (en)<br>
     * [Source ''{0}'' は存在しません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[copyFile_illegalArgument3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyFileIllegalArgument3(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source \"{0}\" does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("copyFile_illegalArgument3");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[copyFile_illegalArgument4]
     *
     * [Source &quot;{0}&quot; exists, but it is a directory.] (en)<br>
     * [Source ''{0}'' は存在しますがディレクトリです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[copyFile_illegalArgument4]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyFileIllegalArgument4(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source \"{0}\" exists, but it is a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("copyFile_illegalArgument4");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[copyFile_illegalArgument5]
     *
     * [Source &quot;{0}&quot; is the same as destination &quot;{1}&quot;.] (en)<br>
     * [Source ''{0}'' とdestination ''{1}'' は同じです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[copyFile_illegalArgument5]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyFileIllegalArgument5(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source \"{0}\" is the same as destination \"{1}\".";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("copyFile_illegalArgument5");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[copyFile_illegalArgument6]
     *
     * [Unable to create the destination &quot;{0}&quot; directory.] (en)<br>
     * [Destination ''{0}'' ディレクトリーは作成できません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[copyFile_illegalArgument6]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyFileIllegalArgument6(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unable to create the destination \"{0}\" directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("copyFile_illegalArgument6");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[copyFile_illegalArgument7]
     *
     * [Destination &quot;{0}&quot; exists, but it is read only.] (en)<br>
     * [Destination ''{0}'' は存在しますが、読み込み専用です。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[copyFile_illegalArgument7]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyFileIllegalArgument7(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Destination \"{0}\" exists, but it is read only.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("copyFile_illegalArgument7");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[doCopyFile_illegalArgument1]
     *
     * [Destination &quot;{0}&quot; exists, but it is a directory.] (en)<br>
     * [Destination ''{0}'' は存在しますがディレクトリーです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[doCopyFile_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDoCopyFileIllegalArgument1(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Destination \"{0}\" exists, but it is a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("doCopyFile_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[doCopyFile_illegalArgument2]
     *
     * [Failed to copy all the contents of &quot;{0}&quot; to &quot;{1}&quot;. Size is different.] (en)<br>
     * [''{0}'' から ''{1}'' へのすべてのコンテンツのコピーに失敗しました。サイズが異なります。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[doCopyFile_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDoCopyFileIllegalArgument2(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to copy all the contents of \"{0}\" to \"{1}\". Size is different.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("doCopyFile_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[deleteDirectory_illegalArgument1]
     *
     * [Could not delete &quot;{0}&quot;.] (en)<br>
     * [''{0}'' を削除できませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[deleteDirectory_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDeleteDirectoryIllegalArgument1(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Could not delete \"{0}\".";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("deleteDirectory_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[cleanDirectory_illegalArgument1]
     *
     * [&quot;{0}&quot; does not exist.] (en)<br>
     * [''{0}'' は存在しませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[cleanDirectory_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCleanDirectoryIllegalArgument1(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "\"{0}\" does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("cleanDirectory_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[cleanDirectory_illegalArgument2]
     *
     * [&quot;{0}&quot; is not a directory.] (en)<br>
     * [''{0}'' はディレクトリーではありません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[cleanDirectory_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCleanDirectoryIllegalArgument2(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "\"{0}\" is not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("cleanDirectory_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[cleanDirectory_illegalArgument3]
     *
     * [Failed to get the listings of &quot;{0}&quot;.] (en)<br>
     * [''{0}'' の一覧取得に失敗しました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[cleanDirectory_illegalArgument3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCleanDirectoryIllegalArgument3(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to get the listings of \"{0}\".";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("cleanDirectory_illegalArgument3");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[forceDelete_illegalArgument1]
     *
     * [&quot;{0}&quot; does not exist.] (en)<br>
     * [''{0}'' は存在しませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[forceDelete_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getForceDeleteIllegalArgument1(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "\"{0}\" does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("forceDelete_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[forceDelete_illegalArgument2]
     *
     * [Could not delete &quot;{0}&quot;.] (en)<br>
     * [''{0}'' を削除できませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[forceDelete_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getForceDeleteIllegalArgument2(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Could not delete \"{0}\".";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("forceDelete_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreFilesMessages], key[relativePath_illegalArgument1]
     *
     * [Failed to get the relative path from the folder &quot;{0}&quot; and the file &quot;{1}&quot;: {2}] (en)<br>
     * [folder ''{0}'' と file ''{1}'' からの相対パスの取得に失敗しました。: {2}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @param arg2 置換文字列{2}を置換する値。java.lang.String型を与えてください。
     * @return key[relativePath_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getRelativePathIllegalArgument1(final String arg0, final String arg1, final String arg2) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to get the relative path from the folder \"{0}\" and the file \"{1}\": {2}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("relativePath_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }
}
