/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.cat.core.valueobject;

/**
 * 処理クラス [BentenApplyFuzzyMatchProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenApplyFuzzyMatchProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * 翻訳メモリーの TMX が格納されているディレクトリ。\n※tmxdir と tmdriverclassname とは両方同時に指定する必要があります。
     *
     * フィールド: [tmxdir]。
     */
    private String fTmxdir;

    /**
     * 翻訳対象となる XLIFF が格納されているディレクトリ。
     *
     * フィールド: [xliffdir]。
     */
    private String fXliffdir;

    /**
     * TMX を検索する際にホワイトスペースを無視するかどうか。
     *
     * フィールド: [ignorewhitespacetmreference]。
     * デフォルト: [false]。
     */
    private boolean fIgnorewhitespacetmreference = false;

    /**
     * TMX を検索する際にニーモニックを無視するかどうか。
     *
     * フィールド: [ignoremnemonickeytmreference]。
     * デフォルト: [false]。
     */
    private boolean fIgnoremnemonickeytmreference = false;

    /**
     * Ant タスクの場合には、TM ドライバーのクラス名を指定します。\n※tmxdir と tmdriverclassname とは両方同時に指定する必要があります。
     *
     * フィールド: [tmdriverclassname]。
     */
    private String fTmdriverclassname;

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [tmxdir] の値を設定します。
     *
     * フィールドの説明: [翻訳メモリーの TMX が格納されているディレクトリ。\n※tmxdir と tmdriverclassname とは両方同時に指定する必要があります。]。
     *
     * @param argTmxdir フィールド[tmxdir]に設定する値。
     */
    public void setTmxdir(final String argTmxdir) {
        fTmxdir = argTmxdir;
    }

    /**
     * フィールド [tmxdir] の値を取得します。
     *
     * フィールドの説明: [翻訳メモリーの TMX が格納されているディレクトリ。\n※tmxdir と tmdriverclassname とは両方同時に指定する必要があります。]。
     *
     * @return フィールド[tmxdir]から取得した値。
     */
    public String getTmxdir() {
        return fTmxdir;
    }

    /**
     * フィールド [xliffdir] の値を設定します。
     *
     * フィールドの説明: [翻訳対象となる XLIFF が格納されているディレクトリ。]。
     *
     * @param argXliffdir フィールド[xliffdir]に設定する値。
     */
    public void setXliffdir(final String argXliffdir) {
        fXliffdir = argXliffdir;
    }

    /**
     * フィールド [xliffdir] の値を取得します。
     *
     * フィールドの説明: [翻訳対象となる XLIFF が格納されているディレクトリ。]。
     *
     * @return フィールド[xliffdir]から取得した値。
     */
    public String getXliffdir() {
        return fXliffdir;
    }

    /**
     * フィールド [ignorewhitespacetmreference] の値を設定します。
     *
     * フィールドの説明: [TMX を検索する際にホワイトスペースを無視するかどうか。]。
     *
     * @param argIgnorewhitespacetmreference フィールド[ignorewhitespacetmreference]に設定する値。
     */
    public void setIgnorewhitespacetmreference(final boolean argIgnorewhitespacetmreference) {
        fIgnorewhitespacetmreference = argIgnorewhitespacetmreference;
    }

    /**
     * フィールド [ignorewhitespacetmreference] の値を取得します。
     *
     * フィールドの説明: [TMX を検索する際にホワイトスペースを無視するかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignorewhitespacetmreference]から取得した値。
     */
    public boolean getIgnorewhitespacetmreference() {
        return fIgnorewhitespacetmreference;
    }

    /**
     * フィールド [ignoremnemonickeytmreference] の値を設定します。
     *
     * フィールドの説明: [TMX を検索する際にニーモニックを無視するかどうか。]。
     *
     * @param argIgnoremnemonickeytmreference フィールド[ignoremnemonickeytmreference]に設定する値。
     */
    public void setIgnoremnemonickeytmreference(final boolean argIgnoremnemonickeytmreference) {
        fIgnoremnemonickeytmreference = argIgnoremnemonickeytmreference;
    }

    /**
     * フィールド [ignoremnemonickeytmreference] の値を取得します。
     *
     * フィールドの説明: [TMX を検索する際にニーモニックを無視するかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignoremnemonickeytmreference]から取得した値。
     */
    public boolean getIgnoremnemonickeytmreference() {
        return fIgnoremnemonickeytmreference;
    }

    /**
     * フィールド [tmdriverclassname] の値を設定します。
     *
     * フィールドの説明: [Ant タスクの場合には、TM ドライバーのクラス名を指定します。\n※tmxdir と tmdriverclassname とは両方同時に指定する必要があります。]。
     *
     * @param argTmdriverclassname フィールド[tmdriverclassname]に設定する値。
     */
    public void setTmdriverclassname(final String argTmdriverclassname) {
        fTmdriverclassname = argTmdriverclassname;
    }

    /**
     * フィールド [tmdriverclassname] の値を取得します。
     *
     * フィールドの説明: [Ant タスクの場合には、TM ドライバーのクラス名を指定します。\n※tmxdir と tmdriverclassname とは両方同時に指定する必要があります。]。
     *
     * @return フィールド[tmdriverclassname]から取得した値。
     */
    public String getTmdriverclassname() {
        return fTmdriverclassname;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.cat.core.valueobject.BentenApplyFuzzyMatchProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",tmxdir=" + fTmxdir);
        buf.append(",xliffdir=" + fXliffdir);
        buf.append(",ignorewhitespacetmreference=" + fIgnorewhitespacetmreference);
        buf.append(",ignoremnemonickeytmreference=" + fIgnoremnemonickeytmreference);
        buf.append(",tmdriverclassname=" + fTmdriverclassname);
        buf.append("]");
        return buf.toString();
    }
}
