/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

import benten.twa.cat.dialogs.ApplyExactMatchDialog;
import benten.twa.cat.messages.BentenApplyExactMatchMessages;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.ui.wizards.AbstractWorkflowDialogWizardPage;

/**
 * 完全一致訳の適用
 *
 * <pre>
 * TMX の完全一致訳を XLIFF に適用します。
 *    1.  未翻訳の翻訳対象に対して訳の適用を試みます。
 *    2.  翻訳単位と完全一致する TMX を探し、翻訳単位に適用します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 完全一致訳適用機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ApplyExactMatchWizardPage2 extends AbstractWorkflowDialogWizardPage {

	/**
	 * 完全一致訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyExactMatchMessages fMsg = new BentenApplyExactMatchMessages();

	/**
	 * コンストラクター。
	 * @param selection 選択
	 */
	protected ApplyExactMatchWizardPage2(final IStructuredSelection selection) {
		super(selection);
		setTitle(fMsg.getWizardPage2Title());
		setDescription(fMsg.getWizardPage2Description());
	}

	@Override
	public AbstractWorkflowDialog createWorkflowDialog(final Composite parent, final IStructuredSelection selection) {
		return new ApplyExactMatchDialog(parent.getShell(), selection);
	}
}
