/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import benten.twa.cat.messages.BentenApplyExistentTranslationMessages;
import benten.twa.ui.wizards.AbstractWorkflowWellcomeWizardPage;

/**
 * 過去訳の適用
 *
 * <pre>
 * 過去訳を XLIFF に適用します。
 *  1.  翻訳単位の id をもとに過去訳を適用します。
 *  2.  翻訳後の XLIFF にある過去訳を、XLIFF に適用します。
 *  3.  この処理では TMX を利用しません。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 過去訳適用機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ApplyExistentTranslationWizardPage extends AbstractWorkflowWellcomeWizardPage {
	/**
	 * 過去訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyExistentTranslationMessages fMsg = new BentenApplyExistentTranslationMessages();

	/**
	 * コンストラクター。
	 */
	protected ApplyExistentTranslationWizardPage() {
		setTitle(fMsg.getWizardPageTitle());
		setDescription(fMsg.getWizardPageDescription());
	}

	@Override
	public void createContent(final Composite composite) {
		final Label label = new Label(composite, SWT.NULL);
		label.setText(fMsg.getWizardPageLabel1());
	}
}
