/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.tmx.core.BentenMergeTmxBatchProcess;
import benten.twa.tmx.core.BentenMergeTmxProcessImpl;
import benten.twa.tmx.core.valueobject.BentenMergeTmxProcessInput;
import benten.twa.tmx.dialogs.MergeTmxDialog;
import benten.twa.tmx.messages.BentenMergeTmxMessages;
import benten.twa.tmx.status.BentenMergeTmxStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.ui.preference.BentenProjectProperty;

/**
 * TMX フラグメントのマージ
 *
 * <pre>
 * TMX フラグメントを TMX にマージします。
 *   1.  TMX の内容を、別の TMX にマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント・マージ機能」に対応します。
 * 
 * @author IGA Tosiki
 */
public class MergeTmxHandler extends AbstractWorkflowHandler {
	/**
	 * TMXマージ機能のためのメッセージ。
	 */
	protected static final BentenMergeTmxMessages fMsg = new BentenMergeTmxMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new MergeTmxDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenMergeTmxStatus status = (BentenMergeTmxStatus) iStatus;

		// このタスクは 1 ファイル対象なので、プログレス総数は固定値とします。
		monitor.beginTask(null, 20);

		final BentenMergeTmxProcessInput input = new BentenMergeTmxProcessInput();
		input.setSourcefile(status.getTargetFile().getAbsolutePath());
		input.setTargetfile(status.getToFile().getAbsolutePath());

		// プロジェクトの翻訳元言語、翻訳先言語の設定を反映。
		final IPreferenceStore projectStore = BentenProjectProperty.getStore(status.getProject());
		input
				.setTranssourcelang(projectStore.getString(BentenProjectProperty.ProjectProperty.TRANS_SOURCE_LANG
						.name()));
		input
				.setTranstargetlang(projectStore.getString(BentenProjectProperty.ProjectProperty.TRANS_TARGET_LANG
						.name()));

		new BentenMergeTmxBatchProcess().validateInput(input);
		final BentenMergeTmxProcessImpl process = new BentenMergeTmxProcessImpl() {
			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
