/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.BentenTwaConstants;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.xliff.messages.BentenMergeXliffMessages;
import benten.twa.xliff.status.BentenMergeXliffStatus;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.ResourceFolderTextField;

/**
 * XLIFF フラグメント・マージ・ダイアログです。
 *
 * XLIFF フラグメントのマージ
 *
 * <pre>
 * XLIFF フラグメントを、もとになった XLIFF にマージします。
 *   1.  翻訳単位の id をもとに、XLIFF をマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式断片抽出・マージ機能: XLIFFフラグメント・マージ機能」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class MergeXliffDialog extends AbstractWorkflowDialog {

	/**
	 * XLIFF マージ機能のためのメッセージ。
	 */
	protected static final BentenMergeXliffMessages fMsg = new BentenMergeXliffMessages();

	/** コントロール・コンテナー */
	private final MergeXliffControls controls = new MergeXliffControls();

	/** コントロール・コンテナー・クラス */
	public static class MergeXliffControls {

		/** 入力ディレクトリー・テキスト */
		public ResourceFolderTextField fromDirText;

		/** 出力ディレクトリー・テキスト */
		public ResourceFolderTextField toDirText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 */
	public MergeXliffDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.fromDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelFromXliffDir());
		controls.fromDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.fromDirText.setText(getSelectionResource().getProject().getName() + "/" //$NON-NLS-1$
					+ BentenTwaConstants.DEFAULT_XLIFF_FRAGMENT_DIR);
		}

		controls.toDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelToXliffDir());
		controls.toDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.toDirText.setText(getSelectionResource().getProject().getName() + "/" //$NON-NLS-1$
					+ BentenTwaConstants.DEFAULT_XLIFF_DIR);
		}
	}

	@Override
	public IStatus getResultStatus() {
		final BentenMergeXliffStatus status = new BentenMergeXliffStatus();
		status.setFromDir(controls.fromDirText.getFile());
		status.setToDir(controls.toDirText.getFile());
		status.setProject(controls.toDirText.getResource());
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.fromDirText);
		validatePath(controls.toDirText);
		validateFromTo(controls.fromDirText, controls.toDirText);
		return UiStatus.OK_STATUS;
	}
}
