/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.twa.xliff.core.BentenMergeXliffBatchProcess;
import benten.twa.xliff.core.BentenMergeXliffProcessImpl;
import benten.twa.xliff.core.valueobject.BentenMergeXliffProcessInput;
import benten.twa.xliff.dialogs.MergeXliffDialog;
import benten.twa.xliff.messages.BentenMergeXliffMessages;
import benten.twa.xliff.status.BentenMergeXliffStatus;

/**
 * XLIFF フラグメント・マージ・ハンドラーです。
 * 
 * XLIFF フラグメントのマージ
 * 
 * <pre>
 * XLIFF フラグメントを、もとになった XLIFF にマージします。
 *   1.  翻訳単位の id をもとに、XLIFF をマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式断片抽出・マージ機能: XLIFFフラグメント・マージ機能」に対応します。
 * 
 * @author KASHIHARA Shinji
 */
public class MergeXliffHandler extends AbstractWorkflowHandler {
	/**
	 * XLIFF マージ機能のためのメッセージ。
	 */
	protected static final BentenMergeXliffMessages fMsg = new BentenMergeXliffMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new MergeXliffDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenMergeXliffStatus status = (BentenMergeXliffStatus) iStatus;

		final BentenMergeXliffProcessInput input = new BentenMergeXliffProcessInput();
		input.setSourcedir(status.getFromDir().getAbsolutePath());
		input.setTargetdir(status.getToDir().getAbsolutePath());
		new BentenMergeXliffBatchProcess().validateInput(input);
		final BentenMergeXliffProcessImpl process = new BentenMergeXliffProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}

			@Override
			public boolean progressInner(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
