/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.process;

import java.util.List;

/**
 * Benten における処理結果情報を伝えるためのバリューオブジェクト。正常、警告の件数などをあらわします。異常については表現がありません。異常の際には、例外を発生させて処理を中断するような仕様となっています。
 */
public class BentenProcessResultInfo {
    /**
     * 正常の件数。
     *
     * フィールド: [successCount]。
     * デフォルト: [0]。
     */
    private int fSuccessCount = 0;

    /**
     * 警告の件数。
     *
     * フィールド: [warningCount]。
     * デフォルト: [0]。
     */
    private int fWarningCount = 0;

    /**
     * スキップした件数。
     *
     * フィールド: [skipCount]。
     * デフォルト: [0]。
     */
    private int fSkipCount = 0;

    /**
     * 処理された単位の件数。
     *
     * フィールド: [unitCount]。
     * デフォルト: [0]。
     */
    private int fUnitCount = 0;

    /**
     * 処理の過程で報告されたメッセージ。
     *
     * フィールド: [messageList]。
     * デフォルト: [new java.util.ArrayList<java.lang.String>()]。
     */
    private List<java.lang.String> fMessageList = new java.util.ArrayList<java.lang.String>();

    /**
     * フィールド [successCount] の値を設定します。
     *
     * フィールドの説明: [正常の件数。]。
     *
     * @param argSuccessCount フィールド[successCount]に設定する値。
     */
    public void setSuccessCount(final int argSuccessCount) {
        fSuccessCount = argSuccessCount;
    }

    /**
     * フィールド [successCount] の値を取得します。
     *
     * フィールドの説明: [正常の件数。]。
     * デフォルト: [0]。
     *
     * @return フィールド[successCount]から取得した値。
     */
    public int getSuccessCount() {
        return fSuccessCount;
    }

    /**
     * フィールド [warningCount] の値を設定します。
     *
     * フィールドの説明: [警告の件数。]。
     *
     * @param argWarningCount フィールド[warningCount]に設定する値。
     */
    public void setWarningCount(final int argWarningCount) {
        fWarningCount = argWarningCount;
    }

    /**
     * フィールド [warningCount] の値を取得します。
     *
     * フィールドの説明: [警告の件数。]。
     * デフォルト: [0]。
     *
     * @return フィールド[warningCount]から取得した値。
     */
    public int getWarningCount() {
        return fWarningCount;
    }

    /**
     * フィールド [skipCount] の値を設定します。
     *
     * フィールドの説明: [スキップした件数。]。
     *
     * @param argSkipCount フィールド[skipCount]に設定する値。
     */
    public void setSkipCount(final int argSkipCount) {
        fSkipCount = argSkipCount;
    }

    /**
     * フィールド [skipCount] の値を取得します。
     *
     * フィールドの説明: [スキップした件数。]。
     * デフォルト: [0]。
     *
     * @return フィールド[skipCount]から取得した値。
     */
    public int getSkipCount() {
        return fSkipCount;
    }

    /**
     * フィールド [unitCount] の値を設定します。
     *
     * フィールドの説明: [処理された単位の件数。]。
     *
     * @param argUnitCount フィールド[unitCount]に設定する値。
     */
    public void setUnitCount(final int argUnitCount) {
        fUnitCount = argUnitCount;
    }

    /**
     * フィールド [unitCount] の値を取得します。
     *
     * フィールドの説明: [処理された単位の件数。]。
     * デフォルト: [0]。
     *
     * @return フィールド[unitCount]から取得した値。
     */
    public int getUnitCount() {
        return fUnitCount;
    }

    /**
     * フィールド [messageList] の値を設定します。
     *
     * フィールドの説明: [処理の過程で報告されたメッセージ。]。
     *
     * @param argMessageList フィールド[messageList]に設定する値。
     */
    public void setMessageList(final List<java.lang.String> argMessageList) {
        fMessageList = argMessageList;
    }

    /**
     * フィールド [messageList] の値を取得します。
     *
     * フィールドの説明: [処理の過程で報告されたメッセージ。]。
     * デフォルト: [new java.util.ArrayList<java.lang.String>()]。
     *
     * @return フィールド[messageList]から取得した値。
     */
    public List<java.lang.String> getMessageList() {
        return fMessageList;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.process.BentenProcessResultInfo[");
        buf.append("successCount=" + fSuccessCount);
        buf.append(",warningCount=" + fWarningCount);
        buf.append(",skipCount=" + fSkipCount);
        buf.append(",unitCount=" + fUnitCount);
        buf.append(",messageList=" + fMessageList);
        buf.append("]");
        return buf.toString();
    }
}
