/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * ワークフロー・ウィザード「ようこそ」ページの基底クラス。
 *
 * @author KASHIHARA Shinji
 */
public abstract class AbstractWorkflowWellcomeWizardPage extends WizardPage {

	/**
	 * コンストラクター。
	 */
	protected AbstractWorkflowWellcomeWizardPage() {
		super(AbstractWorkflowWellcomeWizardPage.class.getName());
	}

	@Override
	public boolean canFlipToNextPage() {
		// ウィザードの最初のページでは「次へ」ボタンは常に有効
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void createControl(final Composite parent) {
		final Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(2, false));
		createContent(composite);
		setControl(composite);
	}

	/**
	 * コンテンツの作成。
	 * @param composite 親コンポジット
	 */
	public abstract void createContent(final Composite composite);
}
