/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.glossary.core;

/**
 * Benten 用語集の検索結果をあらわすクラス。
 */
public class BentenGlossarySearchResult {
    /**
     * 翻訳元の文字列。
     *
     * フィールド: [source]。
     */
    private String fSource;

    /**
     * 翻訳先の文字列。
     *
     * フィールド: [target]。
     */
    private String fTarget;

    /**
     * メモやコメント。
     *
     * フィールド: [note]。
     */
    private String fNote;

    /**
     * フィールド [source] の値を設定します。
     *
     * フィールドの説明: [翻訳元の文字列。]。
     *
     * @param argSource フィールド[source]に設定する値。
     */
    public void setSource(final String argSource) {
        fSource = argSource;
    }

    /**
     * フィールド [source] の値を取得します。
     *
     * フィールドの説明: [翻訳元の文字列。]。
     *
     * @return フィールド[source]から取得した値。
     */
    public String getSource() {
        return fSource;
    }

    /**
     * フィールド [target] の値を設定します。
     *
     * フィールドの説明: [翻訳先の文字列。]。
     *
     * @param argTarget フィールド[target]に設定する値。
     */
    public void setTarget(final String argTarget) {
        fTarget = argTarget;
    }

    /**
     * フィールド [target] の値を取得します。
     *
     * フィールドの説明: [翻訳先の文字列。]。
     *
     * @return フィールド[target]から取得した値。
     */
    public String getTarget() {
        return fTarget;
    }

    /**
     * フィールド [note] の値を設定します。
     *
     * フィールドの説明: [メモやコメント。]。
     *
     * @param argNote フィールド[note]に設定する値。
     */
    public void setNote(final String argNote) {
        fNote = argNote;
    }

    /**
     * フィールド [note] の値を取得します。
     *
     * フィールドの説明: [メモやコメント。]。
     *
     * @return フィールド[note]から取得した値。
     */
    public String getNote() {
        return fNote;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.glossary.core.BentenGlossarySearchResult[");
        buf.append("source=" + fSource);
        buf.append(",target=" + fTarget);
        buf.append(",note=" + fNote);
        buf.append("]");
        return buf.toString();
    }
}
