/*******************************************************************************
 * Copyright (c) 2010  NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.viewers;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;

import benten.ui.views.UiToolkit;

/**
 * 翻訳単位リスト・ページ。
 *
 * <UL>
 * <LI>XLIFF エディターの翻訳単位リストを表示するためのページ・クラスです。
 * </UL>
 *
 * ★基本設計「翻訳支援機能: 翻訳中間形式エディター機能: 翻訳単位選択」に対応します。<br>
 *
 * @author KASHIHARA Shinji
 */
public class TransUnitListPage extends Page {

	/**
	 * Benten が提供する基本的なウィジェットを生成する UI ツールキットのインスタンス。
	 */
	protected final UiToolkit toolkit = new UiToolkit();

	// UI コンテナー
	private Composite control;

	// 翻訳単位ビューアー
	private final TransUnitViewer transUnitViewer;

	/**
	 * コンストラクター。
	 * @param transUnitViewer 翻訳単位ビューアー
	 */
	public TransUnitListPage(final TransUnitViewer transUnitViewer) {
		this.transUnitViewer = transUnitViewer;
	}

	@Override
	public void createControl(final Composite parent) {
		control = toolkit.createComposite(parent, 1, 10);
		control.setLayout(toolkit.createGridLayout(1, 5));
		control.setLayoutData(new GridData(GridData.FILL_BOTH));
		transUnitViewer.createTransUnitListGroup(control);
	}

	@Override
	public Control getControl() {
		return control;
	}

	@Override
	public void setFocus() {
		control.setFocus();
	}
}
