/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.editor;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;

/**
 * XML コンテンツ・アシスト・プロセッサー。
 *
 * <UL>
 * <LI>XML コンテンツ上で用語集のコンテンツ・アシストを可能にするクラスです。
 * <LI>処理は {@link GlossaryAssistProcessor} に委譲されます。
 * </UL>
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class CustomXMLAssistProccessor extends XMLContentAssistProcessor {

	/** 用語集アシスト・プロセッサー */
	private final GlossaryAssistProcessor glossaryAssistProcessor = new GlossaryAssistProcessor();

	@Override
	public char[] getCompletionProposalAutoActivationCharacters() {
		return glossaryAssistProcessor.getCompletionProposalAutoActivationCharacters();
	}

	@Override
	public char[] getContextInformationAutoActivationCharacters() {
		return glossaryAssistProcessor.getContextInformationAutoActivationCharacters();
	}

	@Override
	public IContextInformationValidator getContextInformationValidator() {
		return glossaryAssistProcessor.getContextInformationValidator();
	}

	@Override
	public String getErrorMessage() {
		return glossaryAssistProcessor.getErrorMessage();
	}

	@Override
	public ICompletionProposal[] computeCompletionProposals(final ITextViewer viewer, final int offset) {
		return glossaryAssistProcessor.computeCompletionProposals(viewer, offset);
	}
}
