/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

/**
 * UI マルチ・ステータス。
 *
 * <UL>
 * <LI>ステータスを複数保持するクラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public class UiMultiStatus extends MultiStatus {

	/**
	 * コンストラクター。
	 * @param message メッセージ
	 */
	public UiMultiStatus(final String message) {
		this(IStatus.OK, message);
	}

	/**
	 * コンストラクター。
	 * @param code ステータス・コード
	 * @param message メッセージ
	 */
	public UiMultiStatus(final int code, final String message) {
		super(UiPlugin.getDefault().getPluginId(), code, message, null);
	}
}
