/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.jobs;

import org.eclipse.core.runtime.jobs.ISchedulingRule;

/**
 * Benten スケジューリング・ルール。
 *
 * <UL>
 * <LI>Benten のジョブ実行をブロックするスケジューリング・ルールのシングルトン・クラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public class BentenSchedulingRule implements ISchedulingRule {

	/** このクラスのシングルトン・インスタンス */
	public static BentenSchedulingRule INSTANCE = new BentenSchedulingRule();

	/**
	 * 隠されたコンストラクター。
	 * 
	 * <UL>
	 * <LI>このクラスは直接生成できないようになっています。
	 * <LI>インスタンス生成を抑制するために、コンストラクターは private で修飾されています。
	 * </UL>
	 */
	private BentenSchedulingRule() {
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean contains(final ISchedulingRule rule) {
		return rule == this;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isConflicting(final ISchedulingRule rule) {
		return rule == this;
	}
}
