/* Fith: booting and testing
//
// [Author(s)]
// Joel Rees, from November 2007 (JMR)
// All copyrights claimed and retained by the author(s).
// [License]
// This source may be used under the following conditions:
// * This source must be provided in some reasonable manner 
//   with any object distribution or publication.
// * This license notice may not be removed or modified.
// * Any modifications made to this file and published
//   shall receive the same license.
// * The author(s) make no legal representations whatsoever
//   concerning this source and the abstractions and/or
//   implementations contained therein:
// * Each user assumes all liability and responsibility
//   concerning such use.
// * USE AT YOUR OWN RISK.
// * The author(s) assert and concur that algorithms and 
//   other abstractions are fundamentally not patentable.
// * No other conditions are asserted.
// End of copyright and license notice.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>	/* only for main. */


#define MAIN_H


//#include "bifu_i.h"
#include "bifst_a.h"

/* for debugging */
#if defined TRASH


#endif /* defined TRASH */

int main (int argc, const char * argv[]) 
{	int arg;
	/* setbuf( stdin, NULL ); */
	/* Ultimately, I need to move this to the BIF runtime, 
	// and pass the parameter and environment pointers to the interpreter. 
	// This is stop-gap cade.
	*/
	for ( arg = 1; arg < argc; ++arg )
	{	if ( argv[ arg ][ 0 ] == '-' )
		{	if ( ( argv[ arg ][ 1 ] == 'h' ) || ( argv[ arg ][ 1 ] == '?' ) )
			{
				printf( "%s [ -d<n> [ -ro | -rw | -wo ] [ -s=<limit-size>[K|M] ] <filename> (default -rw) ]\n", argv[ 0 ] );
				return EXIT_SUCCESS;	/* Do I really need write-only? */
			}
			if ( argv[ arg ][ 1 ] == 'd' )
			{	cell_u * driveArray = hDROFFS.parameterLink;
				int drive = (unsigned) argv[ arg ][ 2 ] - '0';
				char const * mode = NULL;
				char const * size = NULL;
				char const * name = NULL;
				++arg;
				if ( ( argv[ arg ][ 0 ] == '-' )
					 && ( ( argv[ arg ][ 1 ] == 'r' ) || ( argv[ arg ][ 1 ] == 'w' ) )
				   )
				{	mode = argv[ arg ] + 1;
					++arg;
				}
				if ( ( argv[ arg ][ 0 ] == '-' ) && ( argv[ arg ][ 1 ] == 's' ) )
				{	size = argv[ arg ] + 2;
					if ( * size == '=' )
					{	++size;
					}
					++arg;
				}
				name = argv[ arg ];
				if ( ( drive >= driveArray[ 0 ].integer ) && ( drive < ( driveArray[ 1 ].integer - driveArray[ 0 ].integer ) ) )
				{	cell_u * driveSpec = driveArray + LINEARRAY_DATAOFFSET 
						+ ( drive * driveArray[ 2 ].integer / sizeof (cell_u) );
					driveSpec[ DRIVE_NAME ].bytep  = (byte_t *) name;
					if ( mode == NULL )
					{	mode = "rw";	/* ugly, ugly */
					}
					driveSpec[ DRIVE_MODE ].bytep = (byte_t *) mode;
					driveSpec[ DRIVE_SIZE ].integer = COCO_SINGLE;
					if ( size != NULL )
					{	char * term = NULL;	/* The version of GCC in Mac OS X 10.3 messed up the declaration of strtoul(). */
						unsigned long usize = strtoul( size, &term, 0 );	/* Really should test overflow. */
						if ( term > size )
						{	usize *= ( * term == 'K' ) ? 0x400 : ( ( * term == 'M' ) ? 0x100000L : 1 );
							driveSpec[ DRIVE_SIZE ].integer = usize;
						}
					}
/* dbg */			printf( "file name: <%s> size: %lu mode: <%s>\n", 
						(char *) driveSpec[ DRIVE_NAME ].bytep,
						(unsigned long) driveSpec[ DRIVE_SIZE ].integer,
						(char *) driveSpec[ DRIVE_MODE ].bytep
/* dbg */			);
					driveSpec[ DRIVE_FILE ].filep = fopen( name, mode );
					if ( driveSpec[ DRIVE_FILE ].filep != NULL )
					{	ORIG.initialDiskOnLine.integer = MSG_DISK_ON_LINE;
/* dbg */				printf( "file open on %s succeeded\n", (char *) driveSpec[ DRIVE_NAME ].bytep );
						if ( fseek( driveSpec[ DRIVE_FILE ].filep, 0L, SEEK_END ) == 0 )
						{	long size = ftell( driveSpec[ DRIVE_FILE ].filep );
/* dbg */					printf( "probed size %ld\n", size );
							if( size > 0 )
							{	driveSpec[ DRIVE_SIZE ].integer = ( size + BWID - 1 ) / BWID;
								rewind( driveSpec[ DRIVE_FILE ].filep );
							}
						}
/* dbg */				printf( "final file size %ld\n", driveSpec[ DRIVE_SIZE ].integer );
					}
					else
					{	fprintf( stderr, "%s failed to open file <%s> -%s on startup.\n", argv[ 0 ], name, mode );
					}
				}
			}
		}
	}
	setjmp( coldBuffer );
	xCOLD();
	{	cell_u * driveArray = hDROFFS.parameterLink;	/* This also should be done in the BIF runtime. */
		int drive;
		for ( drive = driveArray[ 0 ].integer; drive <= driveArray[ 1 ].integer; ++drive )
		{	cell_u * driveSpec = driveArray + 3 + ( drive * driveArray[ 2 ].integer / sizeof (cell_u) );
			if ( driveSpec[ DRIVE_FILE ].filep != NULL )
			{	fclose( driveSpec[ DRIVE_FILE ].filep );
			}
		}
	}
	if ( sysSIG.sinteger < 0 )
	{	fprintf( stderr, "Hard exit: %ld\n", (long) sysSIG.sinteger );
	}
	if ( sysSIG.sinteger > 0 )	/* No, not really, but until I can think of something better. */
	{	fprintf( stderr, "Terminated from %ld or so deep.\n", (long) ( CONTROL_STACK_SIZE - sysSIG.sinteger ) );
	}
	/* printf( "%d\n", dbgL01() ); */
    return sysSIG.sinteger;
}
