<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		Export.class.php
 * @brief		エクスポートクラス
 * @date		2007.03.05
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class Export extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; エクスポート");
		
		$group_dao = new GroupManager();
		$group_array = $group_dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$dao = new BitcubeDB();
		
		if($_POST["mode"] == "export")
		{
			// 更新セットテーブル
			$data["group"] = $dao->GetAll("select * from $dao->group where $dao->group.is_delete = 0");
			// カテゴリテーブル
			$data["category"] = $dao->GetAll("select * from $dao->category where $dao->category.is_delete = 0");
			// 記事テーブル
			$data["entry"] = $dao->GetAll("select * from $dao->entry where $dao->entry.is_delete = 0");
			// テンプレートテーブル
			$data["template"] = $dao->GetAll("select * from $dao->template where $dao->template.is_delete = 0");
			// テンプレートモジュールテーブル
			$data["template_module"] = $dao->GetAll("select * from $dao->template_module where $dao->template_module.is_delete = 0");
			
			$this->assign("data",$data);
			
			header("Pragma: public");
			header("Content-type: text/csv; charset=utf-8");
			header("Content-disposition: attachment; filename=BCDATA.csv");
			echo $this->fetch("../ExportCSV.tpl");
			exit;
		}
		
		$this->template = "Export.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
