<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralSitemapView.class.php
 * @brief		一般用サイトマップビュークラス
 * @date		2007.03.26
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralSitemapManager.class.php");

class GeneralSitemapView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralSitemapManager();
		if(!$dir_name = $dao->getGroupDirName($_GET["group_code"]))
			$this->error("Not Found");
		
		$category_list = $dao->getCategoryCodeList("$dao->category.category_code asc","$dao->category.group_code = ".$_GET["group_code"]);
		$news_list = $dao->getNewsCodeList("$dao->entry.entry_code asc","$dao->entry.group_code = ".$_GET["group_code"]);
		
		$this->assign("dir_name",$dir_name);
		$this->assign("category_list",$category_list);
		$this->assign("news_list",$news_list);
		
		$this->template = "../sitemap.tpl";
	}
	
	function render()
	{
		$this->makeView();
		$this->renderRSSView();
	}
}
