<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TrashDelete.class.php
 * @brief		ごみ箱から削除クラス
 * @date		2007.01.17
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class TrashDelete extends PageRender
{
	function makePage()
	{
		$dao = new EntryManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->delRealEntry($_GET["entry_code"]);
		
		// 更新セットが削除されていて記事が無い場合関連情報を完全に削除
		if($dao->GetCount($dao->group,"is_delete = 1 and group_code = ".$_GET["group_code"]) > 0)
		{
			if($dao->GetCount($dao->entry,"group_code = ".$_GET["group_code"]) == 0)
			{
				$dao->ExecuteDelete($dao->group,"group_code = ".$_GET["group_code"]);
				$dao->ExecuteDelete($dao->category,"group_code = ".$_GET["group_code"]);
				$dao->ExecuteDelete($dao->template,"group_code = ".$_GET["group_code"]);
				$dao->ExecuteDelete($dao->template_module,"group_code = ".$_GET["group_code"]);
				$group_data_dir_delete_flag = true;
			}
		}
		
		if(!$dao->CompleteTrans())
			$this->error("記事の削除に失敗しました。");
		
		system("rm -r \"".DATA_DIR."/".$_GET["group_code"]."/".$_GET["entry_code"]."\" ");
		
		if($group_data_dir_delete_flag)
			system("rm -r \"".DATA_DIR."/".$_GET["group_code"]."\" ");
		
		$send_vars["mode"] = 27;
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
