/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;

public final class HSpaceHandler
implements CommandHandler {
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token2) throws SnuggleParseException {
        String resultSize = this.convertLaTeXSize(builder, parentElement, token2.getArguments()[0]);
        if (resultSize == null) {
            return;
        }
        if (token2.getLatexMode() == LaTeXMode.MATH) {
            Element mspace = builder.appendMathMLElement(parentElement, "mspace");
            mspace.setAttribute("width", resultSize);
        } else {
            Element span2 = builder.appendXHTMLElement(parentElement, "span");
            span2.setAttribute("style", "margin-left:" + resultSize + ";font-size:0");
            builder.appendTextNode(span2, "\u00a0", false);
        }
    }

    public String convertLaTeXSize(DOMBuilder builder, Element parentElement, Token sizeToken) throws SnuggleParseException {
        float resultSize;
        String resultUnits;
        float incomingSize;
        CharSequence latexSize = sizeToken.getSlice().extract();
        Pattern sizePattern = Pattern.compile("\\s*(-?[\\d\\.]+)\\s*(\\w+)\\s*");
        Matcher sizeMatcher = sizePattern.matcher(latexSize);
        if (!sizeMatcher.matches()) {
            builder.appendOrThrowError(parentElement, sizeToken, CoreErrorCode.TDEUN0, latexSize);
            return null;
        }
        String incomingSizeString = sizeMatcher.group(1);
        String incomingUnits = sizeMatcher.group(2);
        try {
            incomingSize = Float.parseFloat(incomingSizeString);
        }
        catch (NumberFormatException e) {
            builder.appendOrThrowError(parentElement, sizeToken, CoreErrorCode.TDEUN1, incomingSizeString, latexSize);
            return null;
        }
        if (incomingUnits.equals("pt") || incomingUnits.equals("in") || incomingUnits.equals("cm") || incomingUnits.equals("mm") || incomingUnits.equals("em") || incomingUnits.equals("ex")) {
            resultUnits = incomingUnits;
            resultSize = incomingSize;
        } else if (incomingUnits.equals("pc")) {
            resultUnits = "pt";
            resultSize = incomingSize * 12.0f;
        } else if (incomingUnits.equals("bp")) {
            resultUnits = "in";
            resultSize = incomingSize / 72.0f;
        } else if (incomingUnits.equals("dd")) {
            resultUnits = "pt";
            resultSize = incomingSize * 1238.0f / 1157.0f;
        } else if (incomingUnits.equals("sp")) {
            resultUnits = "pt";
            resultSize = incomingSize / 65536.0f;
        } else {
            builder.appendOrThrowError(parentElement, sizeToken, CoreErrorCode.TDEUN2, incomingUnits, latexSize);
            return null;
        }
        return Float.valueOf(resultSize) + resultUnits;
    }
}

