/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;

public final class SpaceHandler
implements CommandHandler {
    private final String textString;
    private final String mathWidth;

    public SpaceHandler(String textString, String mathWidth) {
        this.textString = textString;
        this.mathWidth = mathWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token2) {
        if (token2.getLatexMode() == LaTeXMode.MATH) {
            if (this.mathWidth == null) throw new SnuggleLogicException("Spacing token " + token2 + " expectedly used in MATH mode");
            Element mspace = builder.appendMathMLElement(parentElement, "mspace");
            mspace.setAttribute("width", this.mathWidth);
            return;
        } else {
            if (this.textString == null) throw new SnuggleLogicException("Spacing token " + token2 + " expectedly used in TEXT mode");
            builder.appendTextNode(parentElement, this.textString, false);
        }
    }
}

