/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.bli.framework.batch;

import java.util.List;
import java.util.Map;
import jp.sf.bli.framework.common.BusinessLogicException;
import jp.sf.bli.framework.logging.Logging;
import jp.sf.bli.framework.validate.GetMessageDB;
import jp.sf.bli.framework.validate.ValidateCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BusinessLogicValidateBT {
    protected String validateConfigFile = "";
    protected String validateMessageFile = "";
    protected GetMessageDB getMessageDB = null;

    public String getValidateConfigFile() {
        return this.validateConfigFile;
    }

    public void setValidateConfigFile(String validateConfigFile) {
        this.validateConfigFile = validateConfigFile;
    }

    public String getValidateMessageFile() {
        return this.validateMessageFile;
    }

    public void setValidateMessageFile(String validateMessageFile) {
        this.validateMessageFile = validateMessageFile;
    }

    public GetMessageDB getGetMessageDB() {
        return this.getMessageDB;
    }

    public void setGetMessageDB(GetMessageDB getMessageDB) {
        this.getMessageDB = getMessageDB;
    }

    public void doValidate(String loginName, Map<String, Object> inputValueMap, Map<String, Object> outputValueMap) throws BusinessLogicException {
        try {
            this.init(loginName, inputValueMap, outputValueMap);
            this.initProcess(loginName, inputValueMap, outputValueMap);
            this.doValidateMain(loginName, inputValueMap, outputValueMap);
            this.endProcess(loginName, inputValueMap, outputValueMap);
            this.end(loginName, inputValueMap, outputValueMap);
        }
        catch (Exception e) {
            Logging.fatal(this.getClass(), "BLI000032", loginName, "doValidate:BlValidate catch Exception. " + e.getMessage());
            e.printStackTrace();
            throw new BusinessLogicException("");
        }
    }

    protected void init(String loginName, Map<String, Object> inputValueMap, Map<String, Object> outputValueMap) throws Exception {
        Logging.debug(this.getClass(), "BLI000033", loginName, "doBizLogic:BlDo started.");
    }

    protected abstract void initProcess(String var1, Map<String, Object> var2, Map<String, Object> var3) throws Exception;

    protected abstract void doValidateMain(String var1, Map<String, Object> var2, Map<String, Object> var3) throws Exception;

    protected abstract void endProcess(String var1, Map<String, Object> var2, Map<String, Object> var3) throws Exception;

    protected void end(String loginName, Map<String, Object> inputValueMap, Map<String, Object> outputValueMap) throws Exception {
        Logging.debug(this.getClass(), "BLI000034", loginName, "doBizLogic:BlDo Ended.");
    }

    public String validate(String loginName, List<Object[]> checkList, int erroLineFeedType) throws Exception {
        String errorMes = "";
        for (Object[] obj : checkList) {
            errorMes = errorMes + ValidateCtrl.validate(loginName, (String)obj[0], obj[1], erroLineFeedType, this.validateConfigFile, this.validateMessageFile, this.getMessageDB);
        }
        return errorMes;
    }
}

