/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.bli.framework.validate;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import jp.sf.bli.framework.common.util.CastUtil;
import jp.sf.bli.framework.common.util.StrUtil;
import jp.sf.bli.framework.logging.Logging;
import jp.sf.bli.framework.validate.AbstractVlidateObject;
import jp.sf.bli.framework.validate.GetMessageDB;
import jp.sf.bli.framework.validate.ValidateException;

public class ValidateString
extends AbstractVlidateObject {
    public static String validate(String id, ResourceBundle bundleConfing, ResourceBundle bundleMes, String fieldName, Object obj, String errorMesLinefeed, GetMessageDB getMessageDB) throws ValidateException {
        StringBuffer errorMes;
        block19: {
            errorMes = new StringBuffer();
            String chkString = (String)obj;
            Logging.debug(ValidateString.class, "BLI000043", id, "validate fieldName:" + fieldName + " chkString:" + chkString);
            boolean nullChk = ValidateString.chkNameMakeBoolean(id, bundleConfing, fieldName, "nullChk");
            boolean emptyChk = ValidateString.chkNameMakeBoolean(id, bundleConfing, fieldName, "emptyChk");
            int lengthChk = ValidateString.chkNameMakeInt(id, bundleConfing, fieldName, "lengthChk");
            boolean hankakukanaChk = ValidateString.chkNameMakeBoolean(id, bundleConfing, fieldName, "hankakukanaChk");
            boolean hanAlpNumChk = ValidateString.chkNameMakeBoolean(id, bundleConfing, fieldName, "hanAlpNumChk");
            boolean hanAlpChk = ValidateString.chkNameMakeBoolean(id, bundleConfing, fieldName, "hanAlpChk");
            boolean hanNumChk = ValidateString.chkNameMakeBoolean(id, bundleConfing, fieldName, "hanNumChk");
            String dateTimeChk = ValidateString.chkNameMakeString(id, bundleConfing, fieldName, "dateTimeChk");
            String valueChk = ValidateString.chkNameMakeString(id, bundleConfing, fieldName, "valueChk");
            if (nullChk && chkString == null) {
                errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "nullChk", errorMesLinefeed, getMessageDB));
                return errorMes.toString();
            }
            if (chkString == null) {
                return errorMes.toString();
            }
            if (emptyChk && chkString.equals("")) {
                errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "emptyChk", errorMesLinefeed, getMessageDB));
            }
            if (lengthChk != 0) {
                try {
                    if (lengthChk < chkString.getBytes("MS932").length) {
                        errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "lengthChk", errorMesLinefeed, getMessageDB));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            if (hankakukanaChk && StrUtil.charHanKanaCheck(chkString)) {
                errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "hankakukanaChk", errorMesLinefeed, getMessageDB));
            }
            if (hanAlpNumChk && !StrUtil.charHanAlpNum(chkString)) {
                errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "hanAlpNumChk", errorMesLinefeed, getMessageDB));
            }
            if (hanAlpChk && !StrUtil.charHanAlp(chkString)) {
                errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "hanAlpChk", errorMesLinefeed, getMessageDB));
            }
            if (hanNumChk && !StrUtil.charHanNum(chkString)) {
                errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "hanAlpNumChk", errorMesLinefeed, getMessageDB));
            }
            if (valueChk != null) {
                List valueChkArray = CastUtil.string2Array(valueChk, ",");
                boolean ngFlag = true;
                Iterator itr = valueChkArray.iterator();
                String nowChar = "";
                while (itr.hasNext()) {
                    nowChar = (String)itr.next();
                    if (!nowChar.equals(chkString)) continue;
                    ngFlag = false;
                }
                if (ngFlag) {
                    errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "valueChk", errorMesLinefeed, getMessageDB));
                }
            }
            if (dateTimeChk != null) {
                SimpleDateFormat sdfFrom = new SimpleDateFormat(dateTimeChk);
                sdfFrom.setLenient(false);
                try {
                    Date date = sdfFrom.parse(chkString);
                    date.toString();
                    int yFirstIndex = dateTimeChk.indexOf("y");
                    int yLastIndex = dateTimeChk.lastIndexOf("y") + 1;
                    if (yFirstIndex == -1) break block19;
                    for (int i = yFirstIndex; i < yLastIndex; ++i) {
                        if (chkString.substring(i, i + 1).equals("0") || chkString.substring(i, i + 1).equals("1") || chkString.substring(i, i + 1).equals("2") || chkString.substring(i, i + 1).equals("3") || chkString.substring(i, i + 1).equals("4") || chkString.substring(i, i + 1).equals("5") || chkString.substring(i, i + 1).equals("6") || chkString.substring(i, i + 1).equals("7") || chkString.substring(i, i + 1).equals("8") || chkString.substring(i, i + 1).equals("9")) continue;
                        errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "dateTimeChk", errorMesLinefeed, getMessageDB));
                        break;
                    }
                }
                catch (IllegalArgumentException iae) {
                    errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "dateTimeChk", errorMesLinefeed, getMessageDB));
                }
                catch (ParseException e) {
                    errorMes.append(ValidateString.errorMesMake(id, bundleMes, fieldName, "dateTimeChk", errorMesLinefeed, getMessageDB));
                }
            }
        }
        return errorMes.toString();
    }
}

