/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.framework.common;

/**
 * 共通定数クラス
 * 
 * @author takeda
 */
public final class Globals {

    /** StrutsAction 結果ステータス (ログインなし) */
    public static final String STATUS_NO_LOGIN         = "nologin";

    public static final String STATUS_CANT_OPERATION   = "cantOperation";

    /** StrutsAction 結果ステータス (致命的エラー) */
    public static final String STATUS_FATAL            = "fatal";

    /** StrutsAction 結果ステータス (成功) */
    public static final String STATUS_SUCCESS          = "success";

    /** StrutsAction 結果ステータス (失敗) */
    public static final String STATUS_FAILURE          = "failure";

    /** 文字(スラッシュ) */
    public static final String STR_SLASH               = "/";

    /** 文字(改行コード:CRLF) */
    public static final String STR_LINE_SEPARATOR_CRLF = "\r\n";

    /** 文字(改行:HTML) */
    public static final String STR_LINE_SEPARATOR_HTML = "<br>";

    /** 文字(コロン) */
    public static final String STR_COLON               = ":";

    // ---------------------------------------------セッション変数文字列
    
    public static final String SESSION_KEY_MES = "sessionKeyMes";
    
    public static final String SESSION_KEY_ERROR_MES   = "sessionKeyErrorMes";

    public static final String RESULT_FLAG             = "resultFlag";

    public static final String SESSION_KEY_LOGIN_ROLE  = "essionKeyLoginRole";

    public static final String SESSION_KEY_LOGIN_ID    = "sessionKeyLoginId";

    public static final String NO_LOGIN_ID             = "noLognId";

    public static final String MAP_KEY_ERROR_MES = "mapKeyErrorMes";
    
    public static final String MAP_KEY_MES = "mapKeyMes";

    

}
