/*
 * Copyright (c) 2006 - 2006, the original author or authors. All rights
 * reserved. Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. * Redistributions in binary
 * form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided
 * with the distribution. * Neither the name of the University of California,
 * Berkeley nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission. THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sf.bli.framework.validate;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import jp.sf.bli.framework.logging.Logging;

/**
 * Validate処理のファサードクラス
 * 
 * @author takeda 2007/01/30
 */
public class ValidateCtrl {

    /**
     * プロパティファイルに従って、Validate実行を行う
     * 
     * @param ユーザID
     * @param Validateチェックするフィールド名
     * @param Validateチェックするオブジェクト
     * @param エラーが発生した際のエラーメッセー字の改行文字列フラグ
     * @return エラー文字列
     * @throws ValidateException
     */
    public static String validate( String id, String fieldName, Object obj,
            int errorMesLinefeedType, String validateConfigFile,
            String validateMessageFile, GetMessageDB getMessageDB )
            throws ValidateException {

        String errorMes = "";

        try {

            ResourceBundle bundle = ResourceBundle
                    .getBundle( validateConfigFile );

            ResourceBundle bundleMes = ResourceBundle
                    .getBundle( validateMessageFile );

            String type = bundle.getString( fieldName + "_type" );

            String errorMesLinefeed = "";

            // errorMesLinefeedTypeの値でエラーメッセージの改行文字列を決定
            if ( errorMesLinefeedType == 0 ) {
                // CRLF \r\n
                errorMesLinefeed = "\r\n";

            } else if ( errorMesLinefeedType == 1 ) {
                // LF \n
                errorMesLinefeed = "\n";

            } else if ( errorMesLinefeedType == 2 ) {
                // CR \r
                errorMesLinefeed = "\r";

            } else if ( errorMesLinefeedType == 3 ) {
                // <br> + CRLF \r\n
                errorMesLinefeed = "<br />\r\n";

            } else if ( errorMesLinefeedType == 4 ) {
                // <br> + LF \n
                errorMesLinefeed = "<br />\n";

            } else if ( errorMesLinefeedType == 5 ) {
                // <br> + CR \r
                errorMesLinefeed = "<br />\r";

            }

            if ( type.equals( "String" ) ) {

                errorMes = ValidateString.validate( id, bundle, bundleMes,
                        fieldName, obj, errorMesLinefeed, getMessageDB );

            } else if ( type.equals( "Integer" ) ) {

                errorMes = ValidateInteger.validate( id, bundle, bundleMes,
                        fieldName, obj, errorMesLinefeed, getMessageDB );

            }

        } catch ( MissingResourceException e ) {

            Logging.error( ValidateCtrl.class, "BLI000035", id,
                    "ValidateCtrl validateでMissingResourceExceptionが発生 Validate設定ファイル中の "
                            + fieldName + "_type" + "の設定がありません" );

            e.printStackTrace();

            throw new ValidateException(
                    "ValidateCtrl validateでMissingResourceExceptionが発生 Validate設定ファイル中の "
                            + fieldName + "_type" + "の設定がありません" );

        }

        if ( obj == null ) {

            Logging.info( ValidateCtrl.class, "BLI000036", id,
                    "ValidateCtrl validate fieldName:" + fieldName
                            + " Object:null errorMes:" + errorMes );

        } else {

            Logging.info( ValidateCtrl.class, "BLI000037", id,
                    "ValidateCtrl validate fieldName:" + fieldName + " Object:"
                            + obj.toString() + " errorMes:" + errorMes );
        }

        return errorMes;

    }

}
