/*
 * Copyright (c) 2006 - 2006, the original author or authors.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sf.bli.framework.validate;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

import jp.sf.bli.framework.common.util.CastUtil;
import jp.sf.bli.framework.common.util.StrUtil;
import jp.sf.bli.framework.logging.Logging;


/**
 * String型のValidate実行クラス
 * @author takeda
 *
 */
public class ValidateString extends AbstractVlidateObject {

    /**
     * String型のValidateをプロパティに基づいて実行する
     * 
     * @param ユーザID
     * @param Validate用のプロパティファイルが割り当てられたResourceBundle
     * @param Validateを行うフィールド名
     * @param Validateを行うオブジェクト
     * @param エラー文字列改行文字
     * @return エラー文字列
     * @throws ValidateException
     */
    public static String validate(String id, ResourceBundle bundleConfing,ResourceBundle bundleMes,
            String fieldName, Object obj, String errorMesLinefeed,GetMessageDB getMessageDB)
            throws ValidateException {

        StringBuffer errorMes;

        errorMes = new StringBuffer();
        String chkString = (String) obj;

        Logging.debug(ValidateString.class, "BLI000043", id,
                "validate fieldName:" + fieldName + " chkString:" + chkString);

        boolean nullChk = chkNameMakeBoolean(id, bundleConfing, fieldName,
                "nullChk");

        boolean emptyChk = chkNameMakeBoolean(id, bundleConfing, fieldName,
                "emptyChk");

        int lengthChk = chkNameMakeInt(id, bundleConfing, fieldName, "lengthChk");

        boolean hankakukanaChk = chkNameMakeBoolean(id, bundleConfing, fieldName,
                "hankakukanaChk");

        boolean hanAlpNumChk = chkNameMakeBoolean(id, bundleConfing, fieldName,
                "hanAlpNumChk");

        boolean hanAlpChk = chkNameMakeBoolean(id, bundleConfing, fieldName,
                "hanAlpChk");

        boolean hanNumChk = chkNameMakeBoolean(id, bundleConfing, fieldName,
                "hanNumChk");

        String dateTimeChk = chkNameMakeString(id, bundleConfing, fieldName,
                "dateTimeChk");

        String valueChk = chkNameMakeString(id, bundleConfing, fieldName,
                "valueChk");

        if (nullChk) {

            if (chkString == null) {
                // nullをチェックする

                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "nullChk", errorMesLinefeed,getMessageDB));

                // nullが来たらこれ以降のチェックでNullPointerで落ちるので処理を抜ける
                return errorMes.toString();

            }

        }

        if (chkString == null) {

            // nullが来たらこれ以降のチェックでNullPointerで落ちるので処理を抜ける
            return errorMes.toString();

        }

        if (emptyChk) {

            if (chkString.equals("")) {

                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "emptyChk", errorMesLinefeed,getMessageDB));

            }
        }

        if (lengthChk != 0) {

            try {
                if (lengthChk < chkString.getBytes("MS932").length) {

                    errorMes.append(errorMesMake(id, bundleMes, fieldName,
                            "lengthChk", errorMesLinefeed,getMessageDB));

                }
            } catch (UnsupportedEncodingException e) {
            }
        }

        // 半角カナが含まれる場合エラー
        if (hankakukanaChk) {

            if (StrUtil.charHanKanaCheck(chkString)) {

                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "hankakukanaChk", errorMesLinefeed,getMessageDB));

            }

        }

        // 半角アルファベッド・半角数字以外が含まれる場合エラー
        if (hanAlpNumChk) {
            if (StrUtil.charHanAlpNum(chkString) == false) {

                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "hanAlpNumChk", errorMesLinefeed,getMessageDB));

            }

        }

        // 半角アルファベッド以外が含まれる場合エラー
        if (hanAlpChk) {
            if (StrUtil.charHanAlp(chkString) == false) {

                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "hanAlpChk", errorMesLinefeed,getMessageDB));

            }

        }

        // 半角数字以外が含まれる場合エラー
        if (hanNumChk) {
            if (StrUtil.charHanNum(chkString) == false) {

                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "hanAlpNumChk", errorMesLinefeed,getMessageDB));

            }

        }

        // 文字列配列に合致しないとエラー
        if (valueChk != null) {

            // valueChk文字列を,で分割してArrayListに変換
            List valueChkArray = CastUtil.string2Array(valueChk, ",");

            boolean ngFlag = true;

            Iterator itr = valueChkArray.iterator();

            String nowChar = "";

            while (itr.hasNext()) {

                nowChar = (String) itr.next();

                if (nowChar.equals(chkString)) {
                    ngFlag = false;
                }

            }

            if (ngFlag == true) {

                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "valueChk", errorMesLinefeed,getMessageDB));

            }

        }

        // 日付型に変換出来ない場合はエラー
        if (dateTimeChk != null) {

            SimpleDateFormat sdfFrom = new SimpleDateFormat(dateTimeChk);
            sdfFrom.setLenient(false);

            try {

                Date date = (Date) sdfFrom.parse(chkString);
                date.toString();

                /* ---- yyyy部分数字文字列かどうかチェック ---- */

                int yFirstIndex = dateTimeChk.indexOf("y");
                int yLastIndex = dateTimeChk.lastIndexOf("y") + 1;

                if (yFirstIndex != -1) {

                    for (int i = yFirstIndex; i < yLastIndex; i++) {

                        if (chkString.substring(i, i + 1).equals("0")
                                || chkString.substring(i, i + 1).equals("1")
                                || chkString.substring(i, i + 1).equals("2")
                                || chkString.substring(i, i + 1).equals("3")
                                || chkString.substring(i, i + 1).equals("4")
                                || chkString.substring(i, i + 1).equals("5")
                                || chkString.substring(i, i + 1).equals("6")
                                || chkString.substring(i, i + 1).equals("7")
                                || chkString.substring(i, i + 1).equals("8")
                                || chkString.substring(i, i + 1).equals("9")) {

                        } else {
                            errorMes
                                    .append(errorMesMake(id, bundleMes,
                                            fieldName, "dateTimeChk",
                                            errorMesLinefeed,getMessageDB));
                            break;
                        }
                    }

                }

            } catch (IllegalArgumentException iae) {
                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "dateTimeChk", errorMesLinefeed,getMessageDB));
            } catch (ParseException e) {
                errorMes.append(errorMesMake(id, bundleMes, fieldName,
                        "dateTimeChk", errorMesLinefeed,getMessageDB));
            }

        }

        return errorMes.toString();
    }

}
