/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1TagDefault;

/**
 * Indicates default tagging mode specification in a module definition.
 * <p>
 * This annotation is applied to a sub-class of {@code ASN1Module} and indicates
 * 'TagDefault' specification of the module.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see ASN1Module
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ASN1ModuleTags {

	/**
	 * Indicates 'TagDefault' specification.
	 * 
	 * @return The default tagging mode.
	 */
	public ASN1TagDefault value() default ASN1TagDefault.EXPLICIT_TAGS;

}
