/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.exception;

import jp.bitmeister.asn1.type.ASN1Type;

/**
 * The general exception that related to this library and should be caught.
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@SuppressWarnings("serial")
public class ASN1Exception extends Exception {

	protected DetailedMessage message;

	/**
	 * Set detailed message of this exception.
	 * 
	 * @param description
	 *            The description of this exception.
	 * @param cause
	 *            The cause exception of this exception.
	 * @param type
	 *            The ASN.1 type related to this exception.
	 * @param element
	 *            The element name related to this exception.
	 * @param data
	 *            The ASN.1 data related to this exception.
	 */
	public void setMessage(String description, Throwable cause,
			Class<? extends ASN1Type> type, String element, ASN1Type data) {
		message = new DetailedMessage(description, cause, type, element, data);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Throwable#getMessage()
	 */
	@Override
	public String getMessage() {
		if (message != null) {
			return message.getMessage();
		}
		return super.getMessage();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Throwable#getCause()
	 */
	@Override
	public Throwable getCause() {
		return message.getCause();
	}

}
