/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type.builtin;

import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.PrimitiveType;

/**
 * Represents ASN.1 'ANY' type.
 * 
 * <p>
 * An instance of this class represents an 'ANY' type data, and has an
 * {@code ASN1Type} value to contain any type of ASN.1 data.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@ASN1BuiltIn
public class ANY extends PrimitiveType<ASN1Type> {

	/**
	 * Instantiates an empty {@code ANY}.
	 */
	public ANY() {
	}

	/**
	 * Instantiates an {@code ANY} and initialize it with the {@code ASN1Type}
	 * value.
	 * 
	 * @param value
	 *            The ASN.1 data to be assigned.
	 */
	public ANY(ASN1Type value) {
		set(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.bitmeister.asn1.type.PrimitiveType#hasValue()
	 */
	@Override
	public boolean hasValue() {
		if (value() != null) {
			return value().hasValue();
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.bitmeister.asn1.type.ASN1Type#validate()
	 */
	@Override
	public void validate() {
		value().validate();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * jp.bitmeister.asn1.type.ASN1Type#matches(jp.bitmeister.asn1.type.ASN1TagClass
	 * , int)
	 */
	@Override
	public boolean matches(ASN1TagClass tagClass, int tagNumber) {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * jp.bitmeister.asn1.type.ASN1Type#accept(jp.bitmeister.asn1.processor.
	 * ASN1Visitor)
	 */
	@Override
	public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
		return visitor.visit(this);
	}

}
