/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type.useful;

import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;

/**
 * Represents ASN.1 'ObjectDescriptor' type.
 * 
 * <p>
 * An instance of this class represents an 'ObjectDescriptor' type data.
 * Characters which can appear in the {@code ObjectDescriptor} are same as
 * {@code GraphicString} because the 'ObjectDescriptor' type is defined as an
 * implicit tagged 'GraphicString' type.
 * </p>
 * 
 * @see GraphicString
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@ASN1BuiltIn
@ASN1Tag(tagClass = ASN1TagClass.UNIVERSAL, value = 7, tagMode = ASN1TagMode.IMPLICIT)
public class ObjectDescriptor extends GraphicString {

	/**
	 * Instantiates an empty {@code ObjectDescriptor}.
	 */
	public ObjectDescriptor() {
	}

	/**
	 * Instantiates a {@code ObjectDescriptor} and initialize it with the
	 * {@code String} value.
	 * 
	 * @param value
	 *            The value assigned to the instance.
	 */
	public ObjectDescriptor(String value) {
		set(value);
	}

}
